--
-- OVAL-id: OVAL48
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0088' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

