--
-- OVAL-id: OVAL4661
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0772' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 9 Installed

	(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.9')

AND EXISTS

	-- Kerberos 5 installed

	(SELECT 'Kerberos 5 installed' FROM Solaris_FileAttributes WHERE
		FilePath = '/etc/krb5/krb5.conf')

AND NOT EXISTS

	-- Patch 112908-15 or later installed

	(SELECT 'Patch 112908-15 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112908' AND
		PatchVersion >= '15')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Kerberos Key Distribution Center (krb5kdc) running

	(SELECT 'Kerberos Key Distribution Center (krb5kdc) running' FROM Solaris_PSInfo WHERE
		Command LIKE '%krb5kdc%')

--
-- ### END VULNERABLE CONFIGURATION
;

