--
-- OVAL-id: OVAL436
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0073' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mysql-server version is less than 3.23.56-1.9

	(SELECT 'mysql-server version is less than 3.23.56-1.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mysql-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.23.56' AND
		RPMTestedRelease = '1.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mysqld is listening to the network

	(SELECT 'mysqld is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%mysqld%')

--
-- ### END VULNERABLE CONFIGURATION
;

