--
-- OVAL-id: OVAL3872
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0845' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 for Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.3790.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.3790.219

	(SELECT 'the version of mshtml.dll is less than 6.0.3790.219' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 219))))))

AND NOT EXISTS

	-- the patch kb834707 is installed (Hotfix key)

	(SELECT 'the patch kb834707 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB834707' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Users not saving encrypted pages to disk  (DisableCachingOfSSLPages)

	(SELECT 'Users not saving encrypted pages to disk  (DisableCachingOfSSLPages)' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_USERS\S-[-0-9]+\Software\Microsoft\Windows\CurrentVersion\Internet Settings' AND
		EntryName = 'DisableCachingOfSSLPages' AND
		EntryValue != '1')

--
-- ### END VULNERABLE CONFIGURATION
;

