--
-- OVAL-id: OVAL3573
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1142' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- Patch Q329414 Installed

	(SELECT 'Patch Q329414 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329414' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- the version of msadco.dll is less than 2.12.5118.0

	(SELECT 'the version of msadco.dll is less than 2.12.5118.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Common Files\System\msadc\msadco.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'ProgramFilesDir') AND
		(Version1 < 2 OR (Version1 = 2 AND
		(Version2 < 12 OR (Version2 = 12 AND
		(Version3 < 5118 OR Version3 = 5118 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

