--
-- OVAL-id: OVAL3095
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0306' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

NOT EXISTS

	-- Patch KB821557 Installed

	(SELECT 'Patch KB821557 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB821557' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND EXISTS

	-- Version check for XP SP1 and XP no service pack for shell32.dll
	(SELECT 'Version check for XP SP1 and XP no service pack for shell32.dll' FROM Placeholder WHERE

	EXISTS
		-- XP Service Pack 1 and version of Shell32.dll is less than 6.0.2800.1233 
		(SELECT 'XP Service Pack 1 and version of Shell32.dll is less than 6.0.2800.1233 ' FROM Placeholder WHERE

		EXISTS
			-- the version of shell32.dll is less than 6.0.2800.1233 

			(SELECT 'the version of shell32.dll is less than 6.0.2800.1233 ' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 6 OR (Version1 = 6 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 2800 OR Version3 = 2800 AND
				Version4 < 1233))))))

		AND EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1'))

	OR EXISTS
		-- XP no Service Pack installed and version of Shell32.dll is less than 6.0.2600.115
		(SELECT 'XP no Service Pack installed and version of Shell32.dll is less than 6.0.2600.115' FROM Placeholder WHERE

		EXISTS
			-- the version of shell32.dll is less than 6.0.2600.115 

			(SELECT 'the version of shell32.dll is less than 6.0.2600.115 ' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 6 OR (Version1 = 6 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 115))))))

		AND EXISTS
			-- Win2K/XP/2003 service pack 1 (or later) is installed

			(SELECT 'Win2K/XP/2003 service pack 1 (or later) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue IN ('Service Pack 1', 'Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

