--
-- OVAL-id: OVAL2426
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0654' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

NOT EXISTS

	-- Patch 106541-33 or later installed

	(SELECT 'Patch 106541-33 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '106541' AND
		PatchVersion >= '33')

AND NOT EXISTS

	-- Patch 109007-18 or later installed

	(SELECT 'Patch 109007-18 or later installed' FROM Solaris_Patches WHERE
		PatchBase != '109007' AND
		PatchVersion >= '18')

AND NOT EXISTS

	-- Patch 114332-12 or later installed

	(SELECT 'Patch 114332-12 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '114332' AND
		PatchVersion >= '12')

AND EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Basic Security Module enabled

	-- unknown_test
	-- NOTE: grep c2audit /etc/system True if "set c2audit:audit_load = 1" or similiar

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- Auditing Administrative or System-Wide Administrative audit classes

	-- unknown_test
	-- NOTE: egrep ^flags:.*a[sd] /etc/security/audit_control True if any lines returned

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

--
-- ### END VULNERABLE CONFIGURATION
;

