--
-- OVAL-id: OVAL2011
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0914' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 106938-08 or later installed

	(SELECT 'Patch 106938-08 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '106938' AND
		PatchVersion >= '08')

AND NOT EXISTS

	-- Patch 109326-13 or later installed

	(SELECT 'Patch 109326-13 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '109326' AND
		PatchVersion >= '13')

AND NOT EXISTS

	-- Patch 112970-06 or later installed

	(SELECT 'Patch 112970-06 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112970' AND
		PatchVersion >= '06')

AND EXISTS

	-- Core Solaris (SUNWcsu) installed

	(SELECT 'Core Solaris (SUNWcsu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWcsu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- in.named running

	(SELECT 'in.named running' FROM Solaris_PSInfo WHERE
		Command = '/usr/sbin/in.named')

--
-- ### END VULNERABLE CONFIGURATION
;

