--
-- OVAL-id: OVAL1718
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0118' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Version check of Ntoskrnl for NT Terminal Server or NT Workstation
	(SELECT 'Version check of Ntoskrnl for NT Terminal Server or NT Workstation' FROM Placeholder WHERE

	EXISTS
		-- Version Ntoskrnl.exe is less than 4.0.1381.7265 and this is an NT Workstation
		(SELECT 'Version Ntoskrnl.exe is less than 4.0.1381.7265 and this is an NT Workstation' FROM Placeholder WHERE

		EXISTS
			-- The version of Ntoskrnl.exe is less than 4.0.1381.7265

			(SELECT 'The version of Ntoskrnl.exe is less than 4.0.1381.7265' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\System32\Ntoskrnl.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 7265))))))

		AND EXISTS
			-- this is an NT Workstation

			(SELECT 'this is an NT Workstation' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue = 'WinNT'))

	OR EXISTS
		-- This is an NT Terminal Server and the version of Ntoskrnl.exe is less than 4.0.1381.33563
		(SELECT 'This is an NT Terminal Server and the version of Ntoskrnl.exe is less than 4.0.1381.33563' FROM Placeholder WHERE

		EXISTS
			-- The version of Ntoskrnl.exe is less than 4.0.1381.33563

			(SELECT 'The version of Ntoskrnl.exe is less than 4.0.1381.33563' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\System32\Ntoskrnl.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 33563))))))

		AND EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

