--
-- OVAL-id: OVAL139
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-0046' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- For Windows NT 4.0 Workstation, Server and Enterprise Edition
	(SELECT 'For Windows NT 4.0 Workstation, Server and Enterprise Edition' FROM Placeholder WHERE

	EXISTS
		-- File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7064

		(SELECT 'File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7064' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\tcpcfg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 1381 OR Version3 = 1381 AND
			Version4 < 7064))))))

	AND NOT EXISTS
		-- Windows NT 4.0 Security Roll-up Package

		(SELECT 'Windows NT 4.0 Security Roll-up Package' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q299444' AND
			EntryName = 'Installed' AND
			EntryValue = '1'))

AND EXISTS

	-- For Terminal Server
	(SELECT 'For Terminal Server' FROM Placeholder WHERE

	EXISTS
		-- this is an NT Terminal Server

		(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductSuite' AND
			EntryValue = 'Terminal Server')

	AND EXISTS
		-- File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7097

		(SELECT 'File %windir%\system32\tcpcfg.dll version is less than 4.0.1381.7097' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\tcpcfg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 1381 OR Version3 = 1381 AND
			Version4 < 7097)))))))

AND NOT EXISTS

	-- Patch Q265714 Installed

	(SELECT 'Patch Q265714 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q265714' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the SNMP service is enabled

	(SELECT 'the SNMP service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SNMP' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

