--
-- OVAL-id: OVAL120
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File kcms_server exists

	(SELECT 'File kcms_server exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_server')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains kcms_server

	(SELECT 'inetd.conf contains kcms_server' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/bin/kcms_server')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File kcms_server executable and SUID or SGID
	(SELECT 'File kcms_server executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			UEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			GEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

