--
-- OVAL-id: OVAL1025
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0642' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 installed

	(SELECT 'SQL Server 2000 installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.650.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.650.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 650 OR Version3 = 650 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of odsole70.dll is less than 2000.80.606.0

	(SELECT 'the version of odsole70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpqueue.dll is less than 2000.80.606.0

	(SELECT 'the version of xpqueue.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpqueue.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xprepl.dll is less than 2000.80.606.0

	(SELECT 'the version of xprepl.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xprepl.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xplog70.dll is less than 2000.80.606.0

	(SELECT 'the version of xplog70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xplog70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpweb70.dll is less than 2000.80.606.0

	(SELECT 'the version of xpweb70.dll is less than 2000.80.606.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpweb70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 606 OR Version3 = 606 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpstar.dll is less than 2000.80.628.0

	(SELECT 'the version of xpstar.dll is less than 2000.80.628.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpstar.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\AppPaths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 628 OR Version3 = 628 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

