--
-- OVAL-id: OVAL1014
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0875' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2712.0300

	(SELECT 'the version of mshtml.dll is less than 6.0.2712.0300' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2712 OR Version3 = 2712 AND
		Version4 < 0300))))))

AND NOT EXISTS

	-- Patch Q313675 Installed

	(SELECT 'Patch Q313675 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{716E024F-7F74-47F3-B93B-9FF7F3CBF94C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q316059.exe Installed

	(SELECT 'Patch Q316059.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{E81659DF-28E1-4C60-B4B9-00A4BC5FA76D}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319282 Installed

	(SELECT 'Patch Q319282 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Active Setup\Installed Components\{2D5974C5-5185-4f5b-80B6-28015ACDD74C}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q321232 is installed (Installed Components key)

	(SELECT 'the patch q321232 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{D7B44F3E-77D3-44C5-8E03-4222D9A18B7B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q323759 is installed (Installed Components key)

	(SELECT 'the patch q323759 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{61E6EAE5-7821-4AC1-9BBD-AED032A8E273}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q328970 is installed (Installed Components key)

	(SELECT 'the patch q328970 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{FF4DD9CD-F25E-425a-8B5C-A2D062781FBB}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q324929 is installed (Installed Components key)

	(SELECT 'the patch q324929 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{2757B1D6-0367-4663-877C-93ECC5C01BF6}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q832894 is installed (Installed Components key)

	(SELECT 'the patch q832894 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{eddbec60-89cb-44ef-8291-0850fd28ff6a}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File Downloads Not Disabled
	(SELECT 'File Downloads Not Disabled' FROM Placeholder WHERE

	EXISTS
		-- Use Machine Settings

		(SELECT 'Use Machine Settings' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
			EntryName = 'Security_HKLM_only' AND
			EntryValue = '1')

	AND EXISTS
		-- File Downloads Allowed In At Least One Zone

		(SELECT 'File Downloads Allowed In At Least One Zone' FROM Windows_RegistryKeys WHERE
			RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
			EntryName = '1803' AND
			EntryValue != '3'))

--
-- ### END VULNERABLE CONFIGURATION
;

