--
-- OVAL-id: OVAL10
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0652' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File xlock exists

	(SELECT 'File xlock exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xlock')

AND NOT EXISTS

	-- Patch 108652-38 or later installed

	(SELECT 'Patch 108652-38 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '38')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File xlock SUID and executable
	(SELECT 'File xlock SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			SUID = '1')

	AND EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

