-- [Schema]

CREATE TABLE Placeholder (Placeholder VARCHAR(32))
;
INSERT INTO Placeholder VALUES ('RedHat_3.0_20041103')
;

CREATE TABLE RedHat_FileAttributes
	(FilePath                               VARCHAR(4096), 
	FileType                                VARCHAR(32),
	UserID                                  INTEGER,
	GroupID                                 INTEGER,
	Atime                                   INTEGER,
	Ctime                                   INTEGER,
	Mtime                                   INTEGER,
	MD5                                     VARCHAR(128),
	SUID                                    CHAR,
	SGID                                    CHAR,
	STICKY                                  CHAR,
	UREAD                                   CHAR,
	UWRITE                                  CHAR,
	UEXEC                                   CHAR,
	GREAD                                   CHAR,
	GWRITE                                  CHAR,
	GEXEC                                   CHAR,
	OREAD                                   CHAR,
	OWRITE                                  CHAR,
	OEXEC                                   CHAR)
;

CREATE TABLE RedHat_FileAttributes_Conf (FilePath VARCHAR(4096))
;

CREATE TABLE RedHat_InetListeningServers
	(Protocol                               VARCHAR(8),
	LocalFullAddress                        VARCHAR(128),
	LocalAddress                            VARCHAR(128),
	LocalPort                               INTEGER,
	ForeignFullAddress                      VARCHAR(128),
	ForeignAddress                          VARCHAR(128),
	ForeignPort                             INTEGER,
	UserID                                  INTEGER,
	PID                                     INTEGER,
	ProgramName                             VARCHAR(256))
;

CREATE TABLE RedHat_InetListeningServers_Conf (ProgramName VARCHAR(256))
;

CREATE TABLE RedHat_Passwd
	(Username                               VARCHAR(128),
	Password                                VARCHAR(32),
	UserID                                  INTEGER,
	GroupID                                 INTEGER,
	GCOS                                    VARCHAR(256),
	HomeDir                                 VARCHAR(4096),
	LoginShell                              VARCHAR(4096))
;

-- No Conf table needed for password

CREATE TABLE RedHat_PSInfo
	(UserID                                 VARCHAR(128),
	PID                                     INTEGER,
	PPID                                    INTEGER,
	SchedulingClass                         VARCHAR(16),
	Priority                                INTEGER,
	StartTime                               VARCHAR(32),
	TTY                                     INTEGER,
	ExecTime                                VARCHAR(32),
	Command                                 VARCHAR(4096))
;

CREATE TABLE RedHat_PSInfo_Conf (Command VARCHAR(4096))
;
CREATE TABLE RedHat_RPMinfo
	(RPMName                                VARCHAR(256),
	RPMEpoch                                VARCHAR(8),
	RPMVersion                              VARCHAR(32),
	RPMRelease                              VARCHAR(32),
	RPMArch                                 VARCHAR(32))
;

CREATE TABLE RedHat_RPMinfo_Conf (RPMName VARCHAR(256))
;

CREATE TABLE RedHat_RPMVersionCompare
	(RPMName                                VARCHAR(256),
	RPMTestedEpoch                          VARCHAR(8),
	RPMTestedVersion                        VARCHAR(32),
	RPMTestedRelease                        VARCHAR(32),
	RPMInstalledVersion                     VARCHAR(16))
;

CREATE TABLE RedHat_RPMVersionCompare_Conf 
	(RPMName                                VARCHAR(256),
	RPMTestedEpoch                          VARCHAR(8),
	RPMTestedVersion                        VARCHAR(32),
	RPMTestedRelease                        VARCHAR(32))
;

CREATE TABLE RedHat_Shadow
	(Username                               VARCHAR(128),
	Password                                VARCHAR(32),
	ChgLst                                  INTEGER,
	ChgAllow                                INTEGER,
	ChgReq                                  INTEGER,
	ExpWarn                                 INTEGER,
	ExpInact                                INTEGER,
	ExpDate                                 INTEGER,
	PswFlag                                 VARCHAR(32))
;

-- No Conf table needed for shadow probe not implemented

CREATE TABLE RedHat_Uname
	(OSName                                 VARCHAR(32),
	NodeName                                VARCHAR(128),
	OSRelease                               VARCHAR(32),
	OSVersion                               VARCHAR(64),
	MachineClass                            VARCHAR(32),
	ProcessorType                           VARCHAR(32))
;
-- No Conf table needed for Uname

-- [Conf]

-- ============================================================================
-- File Attributes
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/etc/httpd/modules/libphp4.so')
;
-- ============================================================================
-- Inet Listening Servers
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*cupsd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*httpd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*httpd\.worker.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*lpd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*mysqld.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*rpc\.mountd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*sshd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*smtpd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*smbd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*sendmail.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*vsftpd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*xinetd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*ypserv.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*httpd')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*rpc\.mountd')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*snmpd.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*squid.*')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*racoon')
;
INSERT INTO RedHat_InetListeningServers_Conf (ProgramName) VALUES ('PAT|^.*squid')
;
-- ============================================================================
-- File Permissions
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/bin/mount')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/telnet')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/kerberos/bin/telnet')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/rlogin')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/kerberos/bin/rlogin')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ssh')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/kmail')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/cvs')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/proc/tty/driver/serial')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/proc/tty/driver/')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/proc/tty/')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/proc/')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/oocalc')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/oodraw')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/oofice')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ooimpress')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/oowriter')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/sbin/tcpdump')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/lha')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/sbin/utempter')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/balsa')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/eog')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/gs')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/gnupg')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/evolution')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/kdm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/konqueror')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/libexec/filters/psbanner')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/mutt')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pine')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/emacs')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/xemacs')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/sbin/sendmail.sendmail')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/unzip')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/xpdf')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/411toppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/asciitopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/atktopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/bioradtopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/bmptoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/brushtopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/cmuwmtopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/eyuvtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/fiascotopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/fitstopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/fstopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/g3topbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/gemtopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/gemtopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/giftopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/gouldtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/hipstopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/hpcdtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/icontopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ilbmtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/imgtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/jpegtopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/leaftoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/lispmtopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/macptopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/mdatopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/mgrtopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/mtvtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/neotoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/palmtopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pamchannel')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pamcut')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pamdeinterlace')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pamfile')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pamoil')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pamstretch')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pamtopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmclean')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmlife')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmmake')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmmask')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmpage')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmpscale')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmreduce')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtext')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmto10x')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmto4425')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoascii')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoatk')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtobbnbg')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtocmuwm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoepsi')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoepson')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtog3')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtogem')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtogo')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoicon')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtolj')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoln03')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtolps')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtomacp')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtomda')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtomgr')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtonokia')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtopi3')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtopk')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoplot')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoppa')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtopsg3')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoptx')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtowbmp')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtox10bm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoxbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtoybm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmtozinc')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pbmupc')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pcxtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmbentley')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmcrater')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmedge')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmenhance')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmhist')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmkernel')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmnoise')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmnorm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmoil')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmramp')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmslice')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmtexture')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmtofs')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmtolispm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmtopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pgmtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pi1toppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pi3topbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pjtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pktopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pngtopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmalias')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmarith')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmcat')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmcolormap')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmcomp')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmconvol')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmcrop')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmcut')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmdepth')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmenlarge')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmfile')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmflip')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmgamma')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmhisteq')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmhistmap')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnminterp')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnminvert')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmmontage')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmnlfilt')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmnoraw')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmpad')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmpaste')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmpsnr')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmremap')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmrotate')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmscale')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmscalefixed')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmshear')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmsmooth')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmsplit')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtile')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtoddif')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtofiasco')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtofits')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtojpeg')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtopalm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtoplainpnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtopng')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtops')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtorast')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtorle')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtosgi')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtosir')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtotiff')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtotiffcmyk')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pnmtoxwd')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppm3d')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmbrighten')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmchange')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmcie')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmcolormask')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmcolors')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmdim')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmdist')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmdither')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmflash')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmforge')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmhist')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmlabel')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmmake')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmmix')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmnorm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmntsc')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmpat')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmquant')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmqvga')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmrelief')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmshift')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmspread')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoacad')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtobmp')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoeyuv')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtogif')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoicr')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoilbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtojpeg')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoleaf')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtolj')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtomitsu')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtompeg')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoneo')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtopcx')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtopi1')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtopict')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtopj')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtopjxl')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtopuzz')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtorgb3')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtosixel')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtotga')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtouil')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtowinicon')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoxpm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoyuv')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtoyuvsplit')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ppmtv')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/psidtopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/pstopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/qrttoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/rasttopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/rawtopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/rawtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/rgb3toppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/rletopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/sbigtopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/sgitopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/sirtopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/sldtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/spctoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/spottopgm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/sputoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/tgatoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/thinkjettopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/tifftopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/wbmptopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/winicontoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/xbmtopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ximtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/xpmtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/xvminitoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/xwdtopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ybmtopbm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/yuvsplittoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/yuvtoppm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/zeisstopnm')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/X11R6/bin/XFree86')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/gaim')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/slocate')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/mc')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/ethereal')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/sbin/ethereal')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/sbin/tethereal')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/share/services/kfile_vcf.desktop')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/mozilla')
;
INSERT INTO RedHat_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/bin/tethereal')
;
-- ============================================================================
-- Processes
INSERT INTO RedHat_PSInfo_Conf (Command) VALUES ('PAT|^.*rhnsd.*$')
;
-- ============================================================================
-- RPM Info
INSERT INTO RedHat_RPMInfo_Conf (RPMName) VALUES ('LIT|redhat-release')
;
INSERT INTO RedHat_RPMInfo_Conf (RPMName) VALUES ('LIT|kernel')
;
INSERT INTO RedHat_RPMInfo_Conf (RPMName) VALUES ('LIT|php')
;
-- ============================================================================
-- RPM Version Compare
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|balsa','NULL','2.0.6','2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|cups','NULL','1.1.17','13.3')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ddskk','NULL','11.6.0','11.90')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ddskk-xemacs','NULL','11.6.0','11.90')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|eog','NULL','2.2.0','2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal','NULL','0.9.11','0.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal','NULL','0.9.13','1.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal-gnome','NULL','0.9.13','1.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|evolution','NULL','1.2.2','5')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gdm','1','2.4.1.3','5.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ghostscript','NULL','7.05','32.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gnupg','NULL','1.2.1','4')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gtkhtml','NULL','1.1.9','0.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gtkhtml','NULL','1.1.9','0.9.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|httpd','NULL','2.0.40','21.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|httpd','NULL','2.0.40','21.5')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kdebase','6','3.1','15')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|krb5-server','NULL','1.2.7','14')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|krb5-libs','NULL','1.2.7','14')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|krb5-workstation','NULL','1.2.7','14')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.20','13.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.20','18.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.20','19.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kdelibs','6','3.1','12')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|lprng','NULL','3.8.19','3.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|lv','NULL','4.49.4','9.9.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mutt','5','1.4.1','1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mysql-server','NULL','3.23.56','1.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|nfs-utils','NULL','1.0.1','3.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssh-server','NULL','3.5p1','6.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssh-server','NULL','3.5p1','11')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl','NULL','0.9.7a','5')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl-devel','NULL','0.9.7a','5')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl-perl','NULL','0.9.7a','5')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl096','NULL','0.9.6','17')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl096b','NULL','0.9.6b','6')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|pam_smb','NULL','1.1.6','9.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|perl-CGI','2','2.81','88.3')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|php','NULL','4.2.2','17.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|pine','NULL','4.44','19.90.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|postfix','2','1.1.12','1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|samba','NULL','2.2.7a','7.9.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|samba','NULL','2.2.7a','8.9.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|wl','NULL','2.10.1','1.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|wl-xemacs','NULL','2.10.1','1.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|sendmail','NULL','8.12.8','5.90')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|sendmail','NULL','8.12.8','9.90')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|sendmail','NULL','8.12.8','6.90')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|squirrelmail','NULL','1.2.11','1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|unzip','NULL','5.50','33')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|up2date','NULL','3.1.23.1','5')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|vsftpd','NULL','1.1.3','8')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|xinetd','2','2.3.11','1.9.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|xpdf','1','2.0.1','11')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ypserv','NULL','2.8','0.9E')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|pwlib','NULL','1.4.7','4.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|netpbm','NULL','9.24','10.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|netpbm-devel','NULL','9.24','10.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|netpbm-progs','NULL','9.24','10.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|XFree86','NULL','4.3.0','2.90.55')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|netpbm','NULL','9.24','11.30.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|netpbm-devel','NULL','9.24','11.30.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|netpbm-progs','NULL','9.24','11.30.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mutt','5','1.4.1','3.3')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mailman','3','2.1.1','5')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gaim','1','0.75','0.9.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|slocate','NULL','2.7','2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mc','1','4.6.0','7.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kdelibs','6','3.1','13')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.21','9.0.1.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-smp','NULL','2.4.21','9.0.1.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-hugemem','NULL','2.4.21','9.0.1.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|pwlib','NULL','1.4.7','7.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|samba','NULL','3.0.2','6.3E')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mod_python','NULL','3.0.1','4')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|XFree86','NULL','4.3.0','55.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libxml2','NULL','2.5.10','6')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libxml2-devel','NULL','2.5.10','6')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libxml2-python','NULL','2.5.10','6')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.20','30.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-smp','NULL','2.4.20','30.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-bigmem','NULL','2.4.20','30.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mutt','5','1.4.1','3.4')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gdk-pixbuf','1','0.22.0','6.0.3')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gdk-pixbuf-devel','1','0.22.0','6.0.3')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gdk-pixbuf-gnome','1','0.22.0','6.0.3')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gdk-pixbuf','1','0.22.0','6.1.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gdk-pixbuf-devel','1','0.22.0','6.1.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|gdk-pixbuf-gnome','1','0.22.0','6.1.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|tcpdump','14','3.7.2','7.9.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|sysstat','NULL','4.0.7','4.rhl9.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|tcpdump','14','3.7.2','7.E3.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|cvs','NULL','1.11.2','13')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal','NULL','0.10.0a','0.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal=gnome','NULL','0.10.0a','0.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kdepim','6','3.1','6')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.20','28.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-smp','NULL','2.4.20','28.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-bigmem','NULL','2.4.20','28.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|nfs-utils','NULL','1.0.6','7.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|sysstat','NULL','4.0.7','4.EL3.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|httpd','NULL','2.0.40','21.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|httpd','NULL','2.0.46','26.ent')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kdepim','6','3.1.3','3.3')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|cvs','NULL','1.11.2','14')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.21','4.0.2.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-smp','NULL','2.4.21','4.0.2.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-bigmem','NULL','2.4.21','4.0.2.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.21','9.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|net-snmp','NULL','5.0.9','2.30E.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl','NULL','0.9.7a','33.4')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl-devel','NULL','0.9.7a','33.4')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl-perl','NULL','0.9.7a','33.4')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl096b','NULL','0.9.6b','16')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mozilla-nss','37','1.4.2','0.9.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mozilla','37','1.4.2','0.9.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl','NULL','0.9.7a','20.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl-devel','NULL','0.9.7a','20.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl-perl','NULL','0.9.7a','20.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl096','NULL','0.9.6','25.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openssl096b','NULL','0.9.6b','15')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mod_ssl','NULL','2.0.46','32.ent')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|squid','7','2.5STABLE1','3.9')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal','NULL','0.10.3','0.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal-gnome','NULL','0.10.3','0.90.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal','NULL','0.10.3','0.30E.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal-gnome','NULL','0.10.3','0.30E.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|mozilla-nss','37','1.4.2','3.0.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.21','9.0.3.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-smp','NULL','2.4.21','9.0.3.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-hugemem','NULL','2.4.21','9.0.3.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|squid','7','2.5.STABLE3','5.3E')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ipsec-tools','NULL','0.2.5','0.4')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kdelibs','6','3.1.3','6.4')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|rsync','NULL','2.5.7','4.3E')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|cvs','NULL','1.11.2','22')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libpng','2','1.2.2','21')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libpng-devel','2','1.2.2','21')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libpng','NULL','1.0.13','12')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libpng-devel','NULL','1.0.13','12')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','NULL','2.4.21','15.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-unsupported','NULL','2.4.21','15.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|cvs','NULL','1.11.2','18')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|openoffice','NULL','1.1.0','15.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|tcpdump','14','3.7.2','7.E3.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|lha','NULL','1.14i','10.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|utempter','NULL','0.5.5','1.3EL.0')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|squid','7','2.5.STABLE3','6.3E')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal','NULL','0.10.3','0.30E.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|ethereal-gnome','NULL','0.10.3','0.30E.2')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|krb5-libs','NULL','1.2.7','24')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|cvs','NULL','1.11.2','24')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|squirrelmail','NULL','1.4.3','0.e3.1')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel','0','2.4.21','15.0.2.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-hugemem','0','2.4.21','15.0.2.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|kernel-smp','0','2.4.21','15.0.2.EL')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libpng','2','1.2.2','24')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libpng-devel','2','1.2.2','24')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libpng10-devel','0','1.0.13','14')
;
INSERT INTO RedHat_RPMVersionCompare_Conf (RPMName, RPMTestedEpoch, RPMTestedVersion, RPMTestedRelease) VALUES ('LIT|libpng10','0','1.0.13','14')
;

-- [Query]

-- ============================================================================
--
-- OVAL-id: OVAL2
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0140' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- balsa version is less than 2.0.6-2

	(SELECT 'balsa version is less than 2.0.6-2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'balsa' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.6' AND
		RPMTestedRelease = '2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/balsa is executable
	(SELECT '/usr/bin/balsa is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/balsa is executable

		(SELECT '/usr/bin/balsa is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/balsa' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/balsa is executable

		(SELECT '/usr/bin/balsa is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/balsa' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/balsa is executable

		(SELECT '/usr/bin/balsa is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/balsa' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL6
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0195' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- cups version is less than 1.1.17-13.3

	(SELECT 'cups version is less than 1.1.17-13.3' FROM RedHat_RPMVersionCompare WHERE
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.17' AND
		RPMTestedRelease = '13.3' AND
		RPMInstalledVersion = 'earlier' AND
		RPMName = 'cups')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- cupsd listens on the network

	(SELECT 'cupsd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%cupsd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL28
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0539' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable config
	(SELECT 'Vulnerable config' FROM Placeholder WHERE

	EXISTS
		-- ddskk version is less than 11.6.0-11.90

		(SELECT 'ddskk version is less than 11.6.0-11.90' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ddskk' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '11.6.0' AND
			RPMTestedRelease = '11.90' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ddskk-xemacs version is less than 11.6.0-11.90

		(SELECT 'ddskk-xemacs version is less than 11.6.0-11.90' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ddskk-xemacs' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '11.6.0' AND
			RPMTestedRelease = '11.90' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL52
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0165' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- eog version is less than 2.2.0-2

	(SELECT 'eog version is less than 2.2.0-2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'eog' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.2.0' AND
		RPMTestedRelease = '2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- eog is executable
	(SELECT 'eog is executable' FROM Placeholder WHERE

	EXISTS
		-- eog is world-executable

		(SELECT 'eog is world-executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/eog' AND
			OEXEC = '1')

	OR EXISTS
		-- eog is group-executable

		(SELECT 'eog is group-executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/eog' AND
			GEXEC = '1')

	OR EXISTS
		-- eog is owner-executable

		(SELECT 'eog is owner-executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/eog' AND
			UEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL54
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0081' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ethereal version is less than 0.9.11-0.90.1

	(SELECT 'ethereal version is less than 0.9.11-0.90.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ethereal' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.11' AND
		RPMTestedRelease = '0.90.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL55
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0159' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ethereal version is less than 0.9.11-0.90.1

	(SELECT 'ethereal version is less than 0.9.11-0.90.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ethereal' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.11' AND
		RPMTestedRelease = '0.90.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL69
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0356' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.9.13-1.90.1

		(SELECT 'ethereal version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.9.13-1.90.1

		(SELECT 'ethereal-gnome version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL73
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0357' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.9.13-1.90.1

		(SELECT 'ethereal version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.9.13-1.90.1

		(SELECT 'ethereal-gnome version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL75
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0428' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.9.13-1.90.1

		(SELECT 'ethereal version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.9.13-1.90.1

		(SELECT 'ethereal-gnome version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL84
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0429' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.9.13-1.90.1

		(SELECT 'ethereal version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.9.13-1.90.1

		(SELECT 'ethereal-gnome version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL88
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0430' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.9.13-1.90.1

		(SELECT 'ethereal version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.9.13-1.90.1

		(SELECT 'ethereal-gnome version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL101
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0431' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.9.13-1.90.1

		(SELECT 'ethereal version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.9.13-1.90.1

		(SELECT 'ethereal-gnome version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL106
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0432' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.9.13-1.90.1

		(SELECT 'ethereal version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.9.13-1.90.1

		(SELECT 'ethereal-gnome version is less than 0.9.13-1.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.13' AND
			RPMTestedRelease = '1.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL107
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0128' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- evolution version is less than 1.2.2-5

	(SELECT 'evolution version is less than 1.2.2-5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'evolution' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.2' AND
		RPMTestedRelease = '5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL108
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0129' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- evolution version is less than 1.2.2-5

	(SELECT 'evolution version is less than 1.2.2-5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'evolution' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.2' AND
		RPMTestedRelease = '5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL111
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0130' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- evolution version is less than 1.2.2-5

	(SELECT 'evolution version is less than 1.2.2-5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'evolution' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.2' AND
		RPMTestedRelease = '5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL112
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0547' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gdm version is less than 2.4.1.3-5.1

	(SELECT 'gdm version is less than 2.4.1.3-5.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gdm' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '2.4.1.3' AND
		RPMTestedRelease = '5.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL113
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0548' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gdm version is less than 2.4.1.3-5.1

	(SELECT 'gdm version is less than 2.4.1.3-5.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gdm' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '2.4.1.3' AND
		RPMTestedRelease = '5.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL129
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0549' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gdm version is less than 2.4.1.3-5.1

	(SELECT 'gdm version is less than 2.4.1.3-5.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gdm' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '2.4.1.3' AND
		RPMTestedRelease = '5.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL133
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0354' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ghostscript version is less than 7.05-32.1

	(SELECT 'ghostscript version is less than 7.05-32.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ghostscript' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '7.05' AND
		RPMTestedRelease = '32.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/gs is executable
	(SELECT '/usr/bin/gs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/gs is executable

		(SELECT '/usr/bin/gs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/gs is executable

		(SELECT '/usr/bin/gs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/gs is executable

		(SELECT '/usr/bin/gs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL135
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0255' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gnupg version is less than 1.2.1-4

	(SELECT 'gnupg version is less than 1.2.1-4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gnupg' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.1' AND
		RPMTestedRelease = '4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/gnupg is executable
	(SELECT '/usr/bin/gnupg is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/gnupg is executable

		(SELECT '/usr/bin/gnupg is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gnupg' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/gnupg is executable

		(SELECT '/usr/bin/gnupg is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gnupg' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL138
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0133' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gtkhtml version is less than 1.1.9-0.9

	(SELECT 'gtkhtml version is less than 1.1.9-0.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gtkhtml' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.9' AND
		RPMTestedRelease = '0.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL148
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0541' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gtkhtml version is less than 1.1.9-0.9.1

	(SELECT 'gtkhtml version is less than 1.1.9-0.9.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gtkhtml' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.9' AND
		RPMTestedRelease = '0.9.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/evolution is executable
	(SELECT '/usr/bin/evolution is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/evolution is executable

		(SELECT '/usr/bin/evolution is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/evolution' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/evolution is executable

		(SELECT '/usr/bin/evolution is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/evolution' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/evolution is executable

		(SELECT '/usr/bin/evolution is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/evolution' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL150
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0020' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.40-21.1

	(SELECT 'httpd version is less than 2.0.40-21.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.40' AND
		RPMTestedRelease = '21.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd listening on the network

	(SELECT 'httpd listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL151
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0083' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.40-21.1

	(SELECT 'httpd version is less than 2.0.40-21.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.40' AND
		RPMTestedRelease = '21.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd listening on the network

	(SELECT 'httpd listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL156
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0132' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.40-21.1

	(SELECT 'httpd version is less than 2.0.40-21.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.40' AND
		RPMTestedRelease = '21.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd listening on the network

	(SELECT 'httpd listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL169
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0192' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.40-21.5

	(SELECT 'httpd version is less than 2.0.40-21.5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.40' AND
		RPMTestedRelease = '21.5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd.worker is listening on the network

	(SELECT 'httpd.worker is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd.worker%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL173
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0253' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.40-21.5

	(SELECT 'httpd version is less than 2.0.40-21.5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.40' AND
		RPMTestedRelease = '21.5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd listening on the network

	(SELECT 'httpd listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL183
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0254' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.40-21.5

	(SELECT 'httpd version is less than 2.0.40-21.5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.40' AND
		RPMTestedRelease = '21.5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd listening on the network

	(SELECT 'httpd listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL193
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0690' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdebase version is less than 3.1-15

	(SELECT 'kdebase version is less than 3.1-15' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdebase' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1' AND
		RPMTestedRelease = '15' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/kdm is executable
	(SELECT '/usr/bin/kdm is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/kdm is executable

		(SELECT '/usr/bin/kdm is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/kdm' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/kdm is executable

		(SELECT '/usr/bin/kdm is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/kdm' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/kdm is executable

		(SELECT '/usr/bin/kdm is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/kdm' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL215
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0692' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdebase version is less than 3.1-15

	(SELECT 'kdebase version is less than 3.1-15' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdebase' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1' AND
		RPMTestedRelease = '15' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/kdm is executable
	(SELECT '/usr/bin/kdm is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/kdm is executable

		(SELECT '/usr/bin/kdm is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/kdm' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/kdm is executable

		(SELECT '/usr/bin/kdm is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/kdm' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/kdm is executable

		(SELECT '/usr/bin/kdm is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/kdm' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL230
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0028' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- krb5-server version is less than 1.2.7-14

	(SELECT 'krb5-server version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'krb5-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.7' AND
		RPMTestedRelease = '14' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL244
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0082' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- krb5-server version is less than 1.2.7-14

	(SELECT 'krb5-server version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'krb5-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.7' AND
		RPMTestedRelease = '14' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL248
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0138' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- krb5-libs version is less than 1.2.7-14

	(SELECT 'krb5-libs version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'krb5-libs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.7' AND
		RPMTestedRelease = '14' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- krb5-server or krb5-workstation installed
	(SELECT 'krb5-server or krb5-workstation installed' FROM Placeholder WHERE

	EXISTS
		-- krb5-server version is less than 1.2.7-14

		(SELECT 'krb5-server version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'krb5-server' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.2.7' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- krb5-workstation version is less than 1.2.7-14

		(SELECT 'krb5-workstation version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'krb5-workstation' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.2.7' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL250
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0139' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- krb5-libs version is less than 1.2.7-14

	(SELECT 'krb5-libs version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'krb5-libs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.7' AND
		RPMTestedRelease = '14' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- krb5-server or krb5-workstation installed
	(SELECT 'krb5-server or krb5-workstation installed' FROM Placeholder WHERE

	EXISTS
		-- krb5-server version is less than 1.2.7-14

		(SELECT 'krb5-server version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'krb5-server' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.2.7' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- krb5-workstation version is less than 1.2.7-14

		(SELECT 'krb5-workstation version is less than 1.2.7-14' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'krb5-workstation' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.2.7' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL254
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0127' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version = 2.4.20-6

	(SELECT 'kernel version = 2.4.20-6' FROM RedHat_RPMinfo WHERE
		RPMEpoch = 'NULL' AND
		RPMName = 'kernel' AND
		RPMRelease = '6' AND
		RPMVersion = '2.4.20')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- kernel 2.4.20-6 or earlier is running

	(SELECT 'kernel 2.4.20-6 or earlier is running' FROM RedHat_Uname WHERE
		OSRelease = '2.4.20-6')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL260
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0187' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-13.9

	(SELECT 'kernel version is less than 2.4.20-13.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '13.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL261
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0244' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-13.9

	(SELECT 'kernel version is less than 2.4.20-13.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '13.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL278
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0246' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-13.9

	(SELECT 'kernel version is less than 2.4.20-13.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '13.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL284
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0247' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-18.9

	(SELECT 'kernel version is less than 2.4.20-18.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '18.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL292
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0248' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-18.9

	(SELECT 'kernel version is less than 2.4.20-18.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '18.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL295
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0364' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-18.9

	(SELECT 'kernel version is less than 2.4.20-18.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '18.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL304
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0461' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL309
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0462' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL311
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0464' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL327
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0476' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL328
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0501' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL380
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0550' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL384
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0551' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL385
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0552' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL386
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0619' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-13.9

	(SELECT 'kernel version is less than 2.4.20-13.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '13.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL387
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0699' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL401
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0700' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.20-19.9

	(SELECT 'kernel version is less than 2.4.20-19.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.20' AND
		RPMTestedRelease = '19.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL411
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0459' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdelibs version is less than 3.1-12

	(SELECT 'kdelibs version is less than 3.1-12' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdelibs' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1' AND
		RPMTestedRelease = '12' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/konqueror is executable
	(SELECT '/usr/bin/konqueror is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL423
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0136' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- lprng version is less than 3.8.19-3.1

	(SELECT 'lprng version is less than 3.8.19-3.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'lprng' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.8.19' AND
		RPMTestedRelease = '3.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- psbanner is world-executable

	(SELECT 'psbanner is world-executable' FROM RedHat_FileAttributes WHERE
		FilePath = '/usr/libexec/filters/psbanner' AND
		OEXEC = '1')

AND EXISTS

	-- lpd listening on the network

	(SELECT 'lpd listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%lpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL430
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0188' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- lv version is less than 4.49.4-9.9.1

	(SELECT 'lv version is less than 4.49.4-9.9.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'lv' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.49.4' AND
		RPMTestedRelease = '9.9.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL434
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0140' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mutt version is less than 1.4.1-1

	(SELECT 'mutt version is less than 1.4.1-1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mutt' AND
		RPMTestedEpoch = '5' AND
		RPMTestedVersion = '1.4.1' AND
		RPMTestedRelease = '1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mutt is executable
	(SELECT '/usr/bin/mutt is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL436
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0073' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mysql-server version is less than 3.23.56-1.9

	(SELECT 'mysql-server version is less than 3.23.56-1.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mysql-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.23.56' AND
		RPMTestedRelease = '1.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mysqld is listening to the network

	(SELECT 'mysqld is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%mysqld%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL442
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0150' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mysql-server version is less than 3.23.56-1.9

	(SELECT 'mysql-server version is less than 3.23.56-1.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mysql-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.23.56' AND
		RPMTestedRelease = '1.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mysqld is listening to the network

	(SELECT 'mysqld is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%mysqld%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL443
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0252' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- nfs-utils version is less than 1.0.1-3.9

	(SELECT 'nfs-utils version is less than 1.0.1-3.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'nfs-utils' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.0.1' AND
		RPMTestedRelease = '3.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.mountd listens on the network

	(SELECT 'rpc.mountd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%rpc.mountd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL445
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0190' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssh-server version is less than 3.5p1-6.9

	(SELECT 'openssh-server version is less than 3.5p1-6.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssh-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.5p1' AND
		RPMTestedRelease = '6.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- sshd listens on the network

	(SELECT 'sshd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%sshd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL446
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0682' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssh-server version is less than 3.5p1-11

	(SELECT 'openssh-server version is less than 3.5p1-11' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssh-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.5p1' AND
		RPMTestedRelease = '11' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- sshd listens on the network

	(SELECT 'sshd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%sshd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL447
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0693' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssh-server version is less than 3.5p1-11

	(SELECT 'openssh-server version is less than 3.5p1-11' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssh-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.5p1' AND
		RPMTestedRelease = '11' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- sshd listens on the network

	(SELECT 'sshd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%sshd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL452
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0695' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssh-server version is less than 3.5p1-11

	(SELECT 'openssh-server version is less than 3.5p1-11' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssh-server' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.5p1' AND
		RPMTestedRelease = '11' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- sshd listens on the network

	(SELECT 'sshd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%sshd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL461
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0131' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- affected version of SSL and TLS components for OpenSSL
	(SELECT 'affected version of SSL and TLS components for OpenSSL' FROM Placeholder WHERE

	EXISTS
		-- openssl version is less than 0.9.7a-5

		(SELECT 'openssl version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl-devel version is less than 0.9.7a-5

		(SELECT 'openssl-devel version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl-perl version is less than 0.9.7a-5

		(SELECT 'openssl-perl version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl-perl' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl096 version is less than 0.9.6-17

		(SELECT 'openssl096 version is less than 0.9.6-17' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl096' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.6' AND
			RPMTestedRelease = '17' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl096b version is less than 0.9.6b-6

		(SELECT 'openssl096b version is less than 0.9.6b-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl096b' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.6b' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL466
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0147' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- affected version of SSL and TLS components for OpenSSL
	(SELECT 'affected version of SSL and TLS components for OpenSSL' FROM Placeholder WHERE

	EXISTS
		-- openssl version is less than 0.9.7a-5

		(SELECT 'openssl version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl-devel version is less than 0.9.7a-5

		(SELECT 'openssl-devel version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl-perl version is less than 0.9.7a-5

		(SELECT 'openssl-perl version is less than 0.9.7a-5' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl-perl' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.7a' AND
			RPMTestedRelease = '5' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl096 version is less than 0.9.6-17

		(SELECT 'openssl096 version is less than 0.9.6-17' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl096' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.6' AND
			RPMTestedRelease = '17' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- openssl096b version is less than 0.9.6b-6

		(SELECT 'openssl096b version is less than 0.9.6b-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'openssl096b' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.9.6b' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL469
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0686' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- pam_smb version is less than 1.1.6-9.9

	(SELECT 'pam_smb version is less than 1.1.6-9.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'pam_smb' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.6' AND
		RPMTestedRelease = '9.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL470
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0615' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- perl-CGI version is less than 2.81-88.3

	(SELECT 'perl-CGI version is less than 2.81-88.3' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'perl-CGI' AND
		RPMTestedEpoch = '2' AND
		RPMTestedVersion = '2.81' AND
		RPMTestedRelease = '88.3' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL485
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0442' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- php version is less than 4.2.2-17.2

	(SELECT 'php version is less than 4.2.2-17.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'php' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.2.2' AND
		RPMTestedRelease = '17.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL499
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0720' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- pine version is less than 4.44-19.90.0

	(SELECT 'pine version is less than 4.44-19.90.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'pine' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.44' AND
		RPMTestedRelease = '19.90.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/pine is executable
	(SELECT '/usr/bin/pine is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL503
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0721' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- pine version is less than 4.44-19.90.0

	(SELECT 'pine version is less than 4.44-19.90.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'pine' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.44' AND
		RPMTestedRelease = '19.90.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/pine is executable
	(SELECT '/usr/bin/pine is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL522
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0468' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- postfix version is less than 1.1.12-1

	(SELECT 'postfix version is less than 1.1.12-1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'postfix' AND
		RPMTestedEpoch = '2' AND
		RPMTestedVersion = '1.1.12' AND
		RPMTestedRelease = '1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smtpd listens on the network

	(SELECT 'smtpd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smtpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL544
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0540' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- postfix version is less than 1.1.12-1

	(SELECT 'postfix version is less than 1.1.12-1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'postfix' AND
		RPMTestedEpoch = '2' AND
		RPMTestedVersion = '1.1.12' AND
		RPMTestedRelease = '1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smtpd listens on the network

	(SELECT 'smtpd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smtpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL552
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0085' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- samba version is less than 2.2.7a-7.9.0

	(SELECT 'samba version is less than 2.2.7a-7.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'samba' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.2.7a' AND
		RPMTestedRelease = '7.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smbd listens on the network

	(SELECT 'smbd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smbd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL554
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0086' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- samba version is less than 2.2.7a-7.9.0

	(SELECT 'samba version is less than 2.2.7a-7.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'samba' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.2.7a' AND
		RPMTestedRelease = '7.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL564
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0196' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- samba version is less than 2.2.7a-8.9.0

	(SELECT 'samba version is less than 2.2.7a-8.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'samba' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.2.7a' AND
		RPMTestedRelease = '8.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smbd is listening on the network

	(SELECT 'smbd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smbd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL567
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0201' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- samba version is less than 2.2.7a-8.9.0

	(SELECT 'samba version is less than 2.2.7a-8.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'samba' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.2.7a' AND
		RPMTestedRelease = '8.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smbd is listening on the network

	(SELECT 'smbd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smbd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL569
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0440' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- wl version is less than 2.10.1-1.1

		(SELECT 'wl version is less than 2.10.1-1.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'wl' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.10.1' AND
			RPMTestedRelease = '1.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- wl-xemacs version is less than 2.10.1-1.1

		(SELECT 'wl-xemacs version is less than 2.10.1-1.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'wl-xemacs' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.10.1' AND
			RPMTestedRelease = '1.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/emacs is executable
		(SELECT '/usr/bin/emacs is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/emacs is executable

			(SELECT '/usr/bin/emacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/emacs' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/emacs is executable

			(SELECT '/usr/bin/emacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/emacs' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/emacs is executable

			(SELECT '/usr/bin/emacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/emacs' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xemacs is executable
		(SELECT '/usr/bin/xemacs is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xemacs is executable

			(SELECT '/usr/bin/xemacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xemacs' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xemacs is executable

			(SELECT '/usr/bin/xemacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xemacs' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xemacs is executable

			(SELECT '/usr/bin/xemacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xemacs' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL572
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0694' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- sendmail version is less than 8.12.8-5.90

	(SELECT 'sendmail version is less than 8.12.8-5.90' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'sendmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '8.12.8' AND
		RPMTestedRelease = '5.90' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- sendmail is Set-UID
		(SELECT 'sendmail is Set-UID' FROM Placeholder WHERE

		EXISTS
			-- sendmail is Set-UID

			(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				SUID = '1')

		AND EXISTS
			-- sendmail is Set-UID
			(SELECT 'sendmail is Set-UID' FROM Placeholder WHERE

			EXISTS
				-- sendmail is Set-UID

				(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
					FilePath = '/usr/sbin/sendmail.sendmail' AND
					GEXEC = '1')

			OR EXISTS
				-- sendmail is Set-UID

				(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
					FilePath = '/usr/sbin/sendmail.sendmail' AND
					OEXEC = '1')))

	OR EXISTS
		-- sendmail is Set-GID
		(SELECT 'sendmail is Set-GID' FROM Placeholder WHERE

		EXISTS
			-- sendmail is Set-GID

			(SELECT 'sendmail is Set-GID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				SGID = '1')

		AND EXISTS
			-- sendmail is Set-UID

			(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				OEXEC = '1'))

	OR EXISTS
		-- sendmail listening

		(SELECT 'sendmail listening' FROM RedHat_InetListeningServers WHERE
			ProgramName LIKE '%sendmail%' AND
			Protocol = 'TCP'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL595
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0681' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- sendmail version is less than 8.12.8-9.90

	(SELECT 'sendmail version is less than 8.12.8-9.90' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'sendmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '8.12.8' AND
		RPMTestedRelease = '9.90' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- sendmail is Set-UID
		(SELECT 'sendmail is Set-UID' FROM Placeholder WHERE

		EXISTS
			-- sendmail is Set-UID

			(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				SUID = '1')

		AND EXISTS
			-- sendmail is Set-UID
			(SELECT 'sendmail is Set-UID' FROM Placeholder WHERE

			EXISTS
				-- sendmail is Set-UID

				(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
					FilePath = '/usr/sbin/sendmail.sendmail' AND
					GEXEC = '1')

			OR EXISTS
				-- sendmail is Set-UID

				(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
					FilePath = '/usr/sbin/sendmail.sendmail' AND
					OEXEC = '1')))

	OR EXISTS
		-- sendmail is Set-GID
		(SELECT 'sendmail is Set-GID' FROM Placeholder WHERE

		EXISTS
			-- sendmail is Set-GID

			(SELECT 'sendmail is Set-GID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				SGID = '1')

		AND EXISTS
			-- sendmail is Set-UID

			(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				OEXEC = '1'))

	OR EXISTS
		-- sendmail listening

		(SELECT 'sendmail listening' FROM RedHat_InetListeningServers WHERE
			ProgramName LIKE '%sendmail%' AND
			Protocol = 'TCP'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL597
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0688' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- sendmail version is less than 8.12.8-6.90

	(SELECT 'sendmail version is less than 8.12.8-6.90' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'sendmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '8.12.8' AND
		RPMTestedRelease = '6.90' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- sendmail is listening to the network

	(SELECT 'sendmail is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%sendmail%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL603
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0694' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- sendmail version is less than 8.12.8-9.90

	(SELECT 'sendmail version is less than 8.12.8-9.90' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'sendmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '8.12.8' AND
		RPMTestedRelease = '9.90' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- sendmail is Set-UID
		(SELECT 'sendmail is Set-UID' FROM Placeholder WHERE

		EXISTS
			-- sendmail is Set-UID

			(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				SUID = '1')

		AND EXISTS
			-- sendmail is Set-UID
			(SELECT 'sendmail is Set-UID' FROM Placeholder WHERE

			EXISTS
				-- sendmail is Set-UID

				(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
					FilePath = '/usr/sbin/sendmail.sendmail' AND
					GEXEC = '1')

			OR EXISTS
				-- sendmail is Set-UID

				(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
					FilePath = '/usr/sbin/sendmail.sendmail' AND
					OEXEC = '1')))

	OR EXISTS
		-- sendmail is Set-GID
		(SELECT 'sendmail is Set-GID' FROM Placeholder WHERE

		EXISTS
			-- sendmail is Set-GID

			(SELECT 'sendmail is Set-GID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				SGID = '1')

		AND EXISTS
			-- sendmail is Set-UID

			(SELECT 'sendmail is Set-UID' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/sendmail.sendmail' AND
				OEXEC = '1'))

	OR EXISTS
		-- sendmail listening

		(SELECT 'sendmail listening' FROM RedHat_InetListeningServers WHERE
			ProgramName LIKE '%sendmail%' AND
			Protocol = 'TCP'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL614
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0160' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- squirrelmail version is less than 1.2.11-1

	(SELECT 'squirrelmail version is less than 1.2.11-1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squirrelmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.11' AND
		RPMTestedRelease = '1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL619
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0282' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- unzip version is less than 5.50-33

	(SELECT 'unzip version is less than 5.50-33' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'unzip' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '5.50' AND
		RPMTestedRelease = '33' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/unzip is executable
	(SELECT '/usr/bin/unzip is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/unzip is executable

		(SELECT '/usr/bin/unzip is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/unzip' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/unzip is executable

		(SELECT '/usr/bin/unzip is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/unzip' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/unzip is executable

		(SELECT '/usr/bin/unzip is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/unzip' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL631
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0546' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- up2date version is less than 3.1.23.1-5

	(SELECT 'up2date version is less than 3.1.23.1-5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'up2date' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.1.23.1' AND
		RPMTestedRelease = '5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rhnsd is running

	(SELECT 'rhnsd is running' FROM RedHat_PSInfo WHERE
		Command LIKE '%rhnsd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL634
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0135' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- vsftpd version is less than 1.1.3-8

	(SELECT 'vsftpd version is less than 1.1.3-8' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'vsftpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.3' AND
		RPMTestedRelease = '8' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- vsftpd is listening to the network

	(SELECT 'vsftpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%vsftpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL657
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0211' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- xinetd version is less than 2:2.3.11-1.9.0

	(SELECT 'xinetd version is less than 2:2.3.11-1.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'xinetd' AND
		RPMTestedEpoch = '2' AND
		RPMTestedVersion = '2.3.11' AND
		RPMTestedRelease = '1.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- xinetd is listening to the network

	(SELECT 'xinetd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%xinetd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL664
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0434' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- xpdf version is less than 2.0.1-11

	(SELECT 'xpdf version is less than 2.0.1-11' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'xpdf' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '2.0.1' AND
		RPMTestedRelease = '11' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- xpdf is executable
	(SELECT 'xpdf is executable' FROM Placeholder WHERE

	EXISTS
		-- xpdf is executable

		(SELECT 'xpdf is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/xpdf' AND
			UEXEC = '1')

	OR EXISTS
		-- xpdf is executable

		(SELECT 'xpdf is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/xpdf' AND
			GEXEC = '1')

	OR EXISTS
		-- xpdf is executable

		(SELECT 'xpdf is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/xpdf' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL667
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0251' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ypserv version is less than 2.8-0.9E

	(SELECT 'ypserv version is less than 2.8-0.9E' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ypserv' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.8' AND
		RPMTestedRelease = '0.9E' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ypserv is listening on the network

	(SELECT 'ypserv is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%ypserv%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL803
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0097' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- pwlib version is less than 1.4.7-4.1

	(SELECT 'pwlib version is less than 1.4.7-4.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'pwlib' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.4.7' AND
		RPMTestedRelease = '4.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- a program is listening on TCP or UDP port 1720

	(SELECT 'a program is listening on TCP or UDP port 1720' FROM RedHat_InetListeningServers WHERE
		LocalPort = '1720' AND
		ProgramName LIKE '%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL804
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0924' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- netpbm version is less than 9.24-10.90.1

		(SELECT 'netpbm version is less than 9.24-10.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '10.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- netpbm-devel version is less than 9.24-10.90.1

		(SELECT 'netpbm-devel version is less than 9.24-10.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '10.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- netpbm-progs version is less than 9.24-10.90.1

		(SELECT 'netpbm-progs version is less than 9.24-10.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm-progs' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '10.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable configuration
	(SELECT 'Vulnerable configuration' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/411toppm is executable
		(SELECT '/usr/bin/411toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/asciitopgm is executable
		(SELECT '/usr/bin/asciitopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/atktopbm is executable
		(SELECT '/usr/bin/atktopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/bioradtopgm is executable
		(SELECT '/usr/bin/bioradtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/bmptoppm is executable
		(SELECT '/usr/bin/bmptoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/brushtopbm is executable
		(SELECT '/usr/bin/brushtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/cmuwmtopbm is executable
		(SELECT '/usr/bin/cmuwmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/eyuvtoppm is executable
		(SELECT '/usr/bin/eyuvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fiascotopnm is executable
		(SELECT '/usr/bin/fiascotopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fitstopnm is executable
		(SELECT '/usr/bin/fitstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fstopgm is executable
		(SELECT '/usr/bin/fstopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/g3topbm is executable
		(SELECT '/usr/bin/g3topbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gemtopbm is executable
		(SELECT '/usr/bin/gemtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gemtopnm is executable
		(SELECT '/usr/bin/gemtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/giftopnm is executable
		(SELECT '/usr/bin/giftopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gouldtoppm is executable
		(SELECT '/usr/bin/gouldtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/hipstopgm is executable
		(SELECT '/usr/bin/hipstopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/hpcdtoppm is executable
		(SELECT '/usr/bin/hpcdtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/icontopbm is executable
		(SELECT '/usr/bin/icontopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ilbmtoppm is executable
		(SELECT '/usr/bin/ilbmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/imgtoppm is executable
		(SELECT '/usr/bin/imgtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/jpegtopnm is executable
		(SELECT '/usr/bin/jpegtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/leaftoppm is executable
		(SELECT '/usr/bin/leaftoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/lispmtopgm is executable
		(SELECT '/usr/bin/lispmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/macptopbm is executable
		(SELECT '/usr/bin/macptopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mdatopbm is executable
		(SELECT '/usr/bin/mdatopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mgrtopbm is executable
		(SELECT '/usr/bin/mgrtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mtvtoppm is executable
		(SELECT '/usr/bin/mtvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/neotoppm is executable
		(SELECT '/usr/bin/neotoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/palmtopnm is executable
		(SELECT '/usr/bin/palmtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamchannel is executable
		(SELECT '/usr/bin/pamchannel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamcut is executable
		(SELECT '/usr/bin/pamcut is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamdeinterlace is executable
		(SELECT '/usr/bin/pamdeinterlace is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamfile is executable
		(SELECT '/usr/bin/pamfile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamoil is executable
		(SELECT '/usr/bin/pamoil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamstretch is executable
		(SELECT '/usr/bin/pamstretch is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamtopnm is executable
		(SELECT '/usr/bin/pamtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmclean is executable
		(SELECT '/usr/bin/pbmclean is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmlife is executable
		(SELECT '/usr/bin/pbmlife is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmmake is executable
		(SELECT '/usr/bin/pbmmake is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmmask is executable
		(SELECT '/usr/bin/pbmmask is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmpage is executable
		(SELECT '/usr/bin/pbmpage is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmpscale is executable
		(SELECT '/usr/bin/pbmpscale is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmreduce is executable
		(SELECT '/usr/bin/pbmreduce is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtext is executable
		(SELECT '/usr/bin/pbmtext is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmto10x is executable
		(SELECT '/usr/bin/pbmto10x is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmto4425 is executable
		(SELECT '/usr/bin/pbmto4425 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoascii is executable
		(SELECT '/usr/bin/pbmtoascii is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoatk is executable
		(SELECT '/usr/bin/pbmtoatk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtobbnbg is executable
		(SELECT '/usr/bin/pbmtobbnbg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtocmuwm is executable
		(SELECT '/usr/bin/pbmtocmuwm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoepsi is executable
		(SELECT '/usr/bin/pbmtoepsi is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoepson is executable
		(SELECT '/usr/bin/pbmtoepson is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtog3 is executable
		(SELECT '/usr/bin/pbmtog3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtogem is executable
		(SELECT '/usr/bin/pbmtogem is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				OEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				UEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtogo is executable
		(SELECT '/usr/bin/pbmtogo is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoicon is executable
		(SELECT '/usr/bin/pbmtoicon is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtolj is executable
		(SELECT '/usr/bin/pbmtolj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoln03 is executable
		(SELECT '/usr/bin/pbmtoln03 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtolps is executable
		(SELECT '/usr/bin/pbmtolps is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomacp is executable
		(SELECT '/usr/bin/pbmtomacp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomda is executable
		(SELECT '/usr/bin/pbmtomda is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomgr is executable
		(SELECT '/usr/bin/pbmtomgr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtonokia is executable
		(SELECT '/usr/bin/pbmtonokia is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopgm is executable
		(SELECT '/usr/bin/pbmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopi3 is executable
		(SELECT '/usr/bin/pbmtopi3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopk is executable
		(SELECT '/usr/bin/pbmtopk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoplot is executable
		(SELECT '/usr/bin/pbmtoplot is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoppa is executable
		(SELECT '/usr/bin/pbmtoppa is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopsg3 is executable
		(SELECT '/usr/bin/pbmtopsg3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoptx is executable
		(SELECT '/usr/bin/pbmtoptx is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtowbmp is executable
		(SELECT '/usr/bin/pbmtowbmp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtox10bm is executable
		(SELECT '/usr/bin/pbmtox10bm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoxbm is executable
		(SELECT '/usr/bin/pbmtoxbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoybm is executable
		(SELECT '/usr/bin/pbmtoybm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtozinc is executable
		(SELECT '/usr/bin/pbmtozinc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmupc is executable
		(SELECT '/usr/bin/pbmupc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pcxtoppm is executable
		(SELECT '/usr/bin/pcxtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmbentley is executable
		(SELECT '/usr/bin/pgmbentley is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmcrater is executable
		(SELECT '/usr/bin/pgmcrater is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmedge is executable
		(SELECT '/usr/bin/pgmedge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmenhance is executable
		(SELECT '/usr/bin/pgmenhance is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmhist is executable
		(SELECT '/usr/bin/pgmhist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmkernel is executable
		(SELECT '/usr/bin/pgmkernel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmnoise is executable
		(SELECT '/usr/bin/pgmnoise is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmnorm is executable
		(SELECT '/usr/bin/pgmnorm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmoil is executable
		(SELECT '/usr/bin/pgmoil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmramp is executable
		(SELECT '/usr/bin/pgmramp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmslice is executable
		(SELECT '/usr/bin/pgmslice is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtexture is executable
		(SELECT '/usr/bin/pgmtexture is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtofs is executable
		(SELECT '/usr/bin/pgmtofs is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtolispm is executable
		(SELECT '/usr/bin/pgmtolispm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtopbm is executable
		(SELECT '/usr/bin/pgmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtoppm is executable
		(SELECT '/usr/bin/pgmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pi1toppm is executable
		(SELECT '/usr/bin/pi1toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pi3topbm is executable
		(SELECT '/usr/bin/pi3topbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pjtoppm is executable
		(SELECT '/usr/bin/pjtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pktopbm is executable
		(SELECT '/usr/bin/pktopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pngtopnm is executable
		(SELECT '/usr/bin/pngtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmalias is executable
		(SELECT '/usr/bin/pnmalias is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmarith is executable
		(SELECT '/usr/bin/pnmarith is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcat is executable
		(SELECT '/usr/bin/pnmcat is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcolormap is executable
		(SELECT '/usr/bin/pnmcolormap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcomp is executable
		(SELECT '/usr/bin/pnmcomp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmconvol is executable
		(SELECT '/usr/bin/pnmconvol is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcrop is executable
		(SELECT '/usr/bin/pnmcrop is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcut is executable
		(SELECT '/usr/bin/pnmcut is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmdepth is executable
		(SELECT '/usr/bin/pnmdepth is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmenlarge is executable
		(SELECT '/usr/bin/pnmenlarge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmfile is executable
		(SELECT '/usr/bin/pnmfile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmflip is executable
		(SELECT '/usr/bin/pnmflip is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmgamma is executable
		(SELECT '/usr/bin/pnmgamma is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmhisteq is executable
		(SELECT '/usr/bin/pnmhisteq is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmhistmap is executable
		(SELECT '/usr/bin/pnmhistmap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnminterp is executable
		(SELECT '/usr/bin/pnminterp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnminvert is executable
		(SELECT '/usr/bin/pnminvert is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmmontage is executable
		(SELECT '/usr/bin/pnmmontage is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmnlfilt is executable
		(SELECT '/usr/bin/pnmnlfilt is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmnoraw is executable
		(SELECT '/usr/bin/pnmnoraw is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpad is executable
		(SELECT '/usr/bin/pnmpad is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpaste is executable
		(SELECT '/usr/bin/pnmpaste is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpsnr is executable
		(SELECT '/usr/bin/pnmpsnr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmremap is executable
		(SELECT '/usr/bin/pnmremap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmrotate is executable
		(SELECT '/usr/bin/pnmrotate is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmscale is executable
		(SELECT '/usr/bin/pnmscale is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmscalefixed is executable
		(SELECT '/usr/bin/pnmscalefixed is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmshear is executable
		(SELECT '/usr/bin/pnmshear is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmsmooth is executable
		(SELECT '/usr/bin/pnmsmooth is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmsplit is executable
		(SELECT '/usr/bin/pnmsplit is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtile is executable
		(SELECT '/usr/bin/pnmtile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoddif is executable
		(SELECT '/usr/bin/pnmtoddif is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtofiasco is executable
		(SELECT '/usr/bin/pnmtofiasco is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtofits is executable
		(SELECT '/usr/bin/pnmtofits is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtojpeg is executable
		(SELECT '/usr/bin/pnmtojpeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtopalm is executable
		(SELECT '/usr/bin/pnmtopalm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoplainpnm is executable
		(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtopng is executable
		(SELECT '/usr/bin/pnmtopng is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtops is executable
		(SELECT '/usr/bin/pnmtops is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtorast is executable
		(SELECT '/usr/bin/pnmtorast is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtorle is executable
		(SELECT '/usr/bin/pnmtorle is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtosgi is executable
		(SELECT '/usr/bin/pnmtosgi is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtosir is executable
		(SELECT '/usr/bin/pnmtosir is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtotiff is executable
		(SELECT '/usr/bin/pnmtotiff is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtotiffcmyk is executable
		(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoxwd is executable
		(SELECT '/usr/bin/pnmtoxwd is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppm3d is executable
		(SELECT '/usr/bin/ppm3d is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmbrighten is executable
		(SELECT '/usr/bin/ppmbrighten is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmchange is executable
		(SELECT '/usr/bin/ppmchange is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcie is executable
		(SELECT '/usr/bin/ppmcie is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcolormask is executable
		(SELECT '/usr/bin/ppmcolormask is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcolors is executable
		(SELECT '/usr/bin/ppmcolors is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdim is executable
		(SELECT '/usr/bin/ppmdim is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdist is executable
		(SELECT '/usr/bin/ppmdist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdither is executable
		(SELECT '/usr/bin/ppmdither is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmflash is executable
		(SELECT '/usr/bin/ppmflash is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmforge is executable
		(SELECT '/usr/bin/ppmforge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmhist is executable
		(SELECT '/usr/bin/ppmhist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmlabel is executable
		(SELECT '/usr/bin/ppmlabel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmmake is executable
		(SELECT '/usr/bin/ppmmake is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmmix is executable
		(SELECT '/usr/bin/ppmmix is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmnorm is executable
		(SELECT '/usr/bin/ppmnorm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmntsc is executable
		(SELECT '/usr/bin/ppmntsc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmpat is executable
		(SELECT '/usr/bin/ppmpat is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmquant is executable
		(SELECT '/usr/bin/ppmquant is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmqvga is executable
		(SELECT '/usr/bin/ppmqvga is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmrelief is executable
		(SELECT '/usr/bin/ppmrelief is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmshift is executable
		(SELECT '/usr/bin/ppmshift is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmspread is executable
		(SELECT '/usr/bin/ppmspread is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoacad is executable
		(SELECT '/usr/bin/ppmtoacad is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtobmp is executable
		(SELECT '/usr/bin/ppmtobmp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoeyuv is executable
		(SELECT '/usr/bin/ppmtoeyuv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtogif is executable
		(SELECT '/usr/bin/ppmtogif is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoicr is executable
		(SELECT '/usr/bin/ppmtoicr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoilbm is executable
		(SELECT '/usr/bin/ppmtoilbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtojpeg is executable
		(SELECT '/usr/bin/ppmtojpeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoleaf is executable
		(SELECT '/usr/bin/ppmtoleaf is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtolj is executable
		(SELECT '/usr/bin/ppmtolj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtomitsu is executable
		(SELECT '/usr/bin/ppmtomitsu is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtompeg is executable
		(SELECT '/usr/bin/ppmtompeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoneo is executable
		(SELECT '/usr/bin/ppmtoneo is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopcx is executable
		(SELECT '/usr/bin/ppmtopcx is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopgm is executable
		(SELECT '/usr/bin/ppmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopi1 is executable
		(SELECT '/usr/bin/ppmtopi1 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopict is executable
		(SELECT '/usr/bin/ppmtopict is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopj is executable
		(SELECT '/usr/bin/ppmtopj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopjxl is executable
		(SELECT '/usr/bin/ppmtopjxl is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopuzz is executable
		(SELECT '/usr/bin/ppmtopuzz is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtorgb3 is executable
		(SELECT '/usr/bin/ppmtorgb3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtosixel is executable
		(SELECT '/usr/bin/ppmtosixel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtotga is executable
		(SELECT '/usr/bin/ppmtotga is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtouil is executable
		(SELECT '/usr/bin/ppmtouil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtowinicon is executable
		(SELECT '/usr/bin/ppmtowinicon is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoxpm is executable
		(SELECT '/usr/bin/ppmtoxpm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoyuv is executable
		(SELECT '/usr/bin/ppmtoyuv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoyuvsplit is executable
		(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtv is executable
		(SELECT '/usr/bin/ppmtv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/psidtopgm is executable
		(SELECT '/usr/bin/psidtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pstopnm is executable
		(SELECT '/usr/bin/pstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/qrttoppm is executable
		(SELECT '/usr/bin/qrttoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rasttopnm is executable
		(SELECT '/usr/bin/rasttopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rawtopgm is executable
		(SELECT '/usr/bin/rawtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rawtoppm is executable
		(SELECT '/usr/bin/rawtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rgb3toppm is executable
		(SELECT '/usr/bin/rgb3toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rletopnm is executable
		(SELECT '/usr/bin/rletopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sbigtopgm is executable
		(SELECT '/usr/bin/sbigtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sgitopnm is executable
		(SELECT '/usr/bin/sgitopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sirtopnm is executable
		(SELECT '/usr/bin/sirtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sldtoppm is executable
		(SELECT '/usr/bin/sldtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/spctoppm is executable
		(SELECT '/usr/bin/spctoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/spottopgm is executable
		(SELECT '/usr/bin/spottopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sputoppm is executable
		(SELECT '/usr/bin/sputoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tgatoppm is executable
		(SELECT '/usr/bin/tgatoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/thinkjettopbm is executable
		(SELECT '/usr/bin/thinkjettopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tifftopnm is executable
		(SELECT '/usr/bin/tifftopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/wbmptopbm is executable
		(SELECT '/usr/bin/wbmptopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/winicontoppm is executable
		(SELECT '/usr/bin/winicontoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xbmtopbm is executable
		(SELECT '/usr/bin/xbmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ximtoppm is executable
		(SELECT '/usr/bin/ximtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xpmtoppm is executable
		(SELECT '/usr/bin/xpmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xvminitoppm is executable
		(SELECT '/usr/bin/xvminitoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xwdtopnm is executable
		(SELECT '/usr/bin/xwdtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ybmtopbm is executable
		(SELECT '/usr/bin/ybmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/yuvsplittoppm is executable
		(SELECT '/usr/bin/yuvsplittoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/yuvtoppm is executable
		(SELECT '/usr/bin/yuvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/zeisstopnm is executable
		(SELECT '/usr/bin/zeisstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL806
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0083' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- XFree86 version is less than 4.3.0-2.90.55

	(SELECT 'XFree86 version is less than 4.3.0-2.90.55' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'XFree86' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.3.0' AND
		RPMTestedRelease = '2.90.55' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/X11R6/bin/XFree86 is SUID and executable
	(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable

		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/X11R6/bin/XFree86' AND
			SUID = '1')

	AND EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable
		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL807
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0084' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- XFree86 version is less than 4.3.0-2.90.55

	(SELECT 'XFree86 version is less than 4.3.0-2.90.55' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'XFree86' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.3.0' AND
		RPMTestedRelease = '2.90.55' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/X11R6/bin/XFree86 is SUID and executable
	(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable

		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/X11R6/bin/XFree86' AND
			SUID = '1')

	AND EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable
		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL809
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0106' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- XFree86 version is less than 4.3.0-2.90.55

	(SELECT 'XFree86 version is less than 4.3.0-2.90.55' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'XFree86' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.3.0' AND
		RPMTestedRelease = '2.90.55' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/X11R6/bin/XFree86 is SUID and executable
	(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable

		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/X11R6/bin/XFree86' AND
			SUID = '1')

	AND EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable
		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL810
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0924' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- netpbm version is less than 9.24-11.30.1

		(SELECT 'netpbm version is less than 9.24-11.30.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '11.30.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- netpbm-devel version is less than 9.24-11.30.1

		(SELECT 'netpbm-devel version is less than 9.24-11.30.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '11.30.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- netpbm-progs version is less than 9.24-11.30.1

		(SELECT 'netpbm-progs version is less than 9.24-11.30.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'netpbm-progs' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '9.24' AND
			RPMTestedRelease = '11.30.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable configuration
	(SELECT 'Vulnerable configuration' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/411toppm is executable
		(SELECT '/usr/bin/411toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/411toppm is executable

			(SELECT '/usr/bin/411toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/411toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/asciitopgm is executable
		(SELECT '/usr/bin/asciitopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/asciitopgm is executable

			(SELECT '/usr/bin/asciitopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/asciitopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/atktopbm is executable
		(SELECT '/usr/bin/atktopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/atktopbm is executable

			(SELECT '/usr/bin/atktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/atktopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/bioradtopgm is executable
		(SELECT '/usr/bin/bioradtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/bioradtopgm is executable

			(SELECT '/usr/bin/bioradtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bioradtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/bmptoppm is executable
		(SELECT '/usr/bin/bmptoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/bmptoppm is executable

			(SELECT '/usr/bin/bmptoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/bmptoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/brushtopbm is executable
		(SELECT '/usr/bin/brushtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/brushtopbm is executable

			(SELECT '/usr/bin/brushtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/brushtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/cmuwmtopbm is executable
		(SELECT '/usr/bin/cmuwmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/cmuwmtopbm is executable

			(SELECT '/usr/bin/cmuwmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/cmuwmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/eyuvtoppm is executable
		(SELECT '/usr/bin/eyuvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/eyuvtoppm is executable

			(SELECT '/usr/bin/eyuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/eyuvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fiascotopnm is executable
		(SELECT '/usr/bin/fiascotopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fiascotopnm is executable

			(SELECT '/usr/bin/fiascotopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fiascotopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fitstopnm is executable
		(SELECT '/usr/bin/fitstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fitstopnm is executable

			(SELECT '/usr/bin/fitstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fitstopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/fstopgm is executable
		(SELECT '/usr/bin/fstopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/fstopgm is executable

			(SELECT '/usr/bin/fstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/fstopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/g3topbm is executable
		(SELECT '/usr/bin/g3topbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/g3topbm is executable

			(SELECT '/usr/bin/g3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/g3topbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gemtopbm is executable
		(SELECT '/usr/bin/gemtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopbm is executable

			(SELECT '/usr/bin/gemtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gemtopnm is executable
		(SELECT '/usr/bin/gemtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gemtopnm is executable

			(SELECT '/usr/bin/gemtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gemtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/giftopnm is executable
		(SELECT '/usr/bin/giftopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/giftopnm is executable

			(SELECT '/usr/bin/giftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/giftopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/gouldtoppm is executable
		(SELECT '/usr/bin/gouldtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/gouldtoppm is executable

			(SELECT '/usr/bin/gouldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/gouldtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/hipstopgm is executable
		(SELECT '/usr/bin/hipstopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/hipstopgm is executable

			(SELECT '/usr/bin/hipstopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hipstopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/hpcdtoppm is executable
		(SELECT '/usr/bin/hpcdtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/hpcdtoppm is executable

			(SELECT '/usr/bin/hpcdtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/hpcdtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/icontopbm is executable
		(SELECT '/usr/bin/icontopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/icontopbm is executable

			(SELECT '/usr/bin/icontopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/icontopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ilbmtoppm is executable
		(SELECT '/usr/bin/ilbmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ilbmtoppm is executable

			(SELECT '/usr/bin/ilbmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ilbmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/imgtoppm is executable
		(SELECT '/usr/bin/imgtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/imgtoppm is executable

			(SELECT '/usr/bin/imgtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/imgtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/jpegtopnm is executable
		(SELECT '/usr/bin/jpegtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/jpegtopnm is executable

			(SELECT '/usr/bin/jpegtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/jpegtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/leaftoppm is executable
		(SELECT '/usr/bin/leaftoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/leaftoppm is executable

			(SELECT '/usr/bin/leaftoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/leaftoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/lispmtopgm is executable
		(SELECT '/usr/bin/lispmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/lispmtopgm is executable

			(SELECT '/usr/bin/lispmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/lispmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/macptopbm is executable
		(SELECT '/usr/bin/macptopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/macptopbm is executable

			(SELECT '/usr/bin/macptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/macptopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mdatopbm is executable
		(SELECT '/usr/bin/mdatopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mdatopbm is executable

			(SELECT '/usr/bin/mdatopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mdatopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mgrtopbm is executable
		(SELECT '/usr/bin/mgrtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mgrtopbm is executable

			(SELECT '/usr/bin/mgrtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mgrtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/mtvtoppm is executable
		(SELECT '/usr/bin/mtvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/mtvtoppm is executable

			(SELECT '/usr/bin/mtvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/mtvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/neotoppm is executable
		(SELECT '/usr/bin/neotoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/neotoppm is executable

			(SELECT '/usr/bin/neotoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/neotoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/palmtopnm is executable
		(SELECT '/usr/bin/palmtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/palmtopnm is executable

			(SELECT '/usr/bin/palmtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/palmtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamchannel is executable
		(SELECT '/usr/bin/pamchannel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamchannel is executable

			(SELECT '/usr/bin/pamchannel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamchannel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamcut is executable
		(SELECT '/usr/bin/pamcut is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamcut is executable

			(SELECT '/usr/bin/pamcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamcut' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamdeinterlace is executable
		(SELECT '/usr/bin/pamdeinterlace is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamdeinterlace is executable

			(SELECT '/usr/bin/pamdeinterlace is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamdeinterlace' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamfile is executable
		(SELECT '/usr/bin/pamfile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamfile is executable

			(SELECT '/usr/bin/pamfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamfile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamoil is executable
		(SELECT '/usr/bin/pamoil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamoil is executable

			(SELECT '/usr/bin/pamoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamoil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamstretch is executable
		(SELECT '/usr/bin/pamstretch is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamstretch is executable

			(SELECT '/usr/bin/pamstretch is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamstretch' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pamtopnm is executable
		(SELECT '/usr/bin/pamtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pamtopnm is executable

			(SELECT '/usr/bin/pamtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pamtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmclean is executable
		(SELECT '/usr/bin/pbmclean is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmclean is executable

			(SELECT '/usr/bin/pbmclean is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmclean' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmlife is executable
		(SELECT '/usr/bin/pbmlife is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmlife is executable

			(SELECT '/usr/bin/pbmlife is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmlife' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmmake is executable
		(SELECT '/usr/bin/pbmmake is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmake is executable

			(SELECT '/usr/bin/pbmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmake' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmmask is executable
		(SELECT '/usr/bin/pbmmask is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmmask is executable

			(SELECT '/usr/bin/pbmmask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmmask' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmpage is executable
		(SELECT '/usr/bin/pbmpage is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpage is executable

			(SELECT '/usr/bin/pbmpage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpage' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmpscale is executable
		(SELECT '/usr/bin/pbmpscale is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmpscale is executable

			(SELECT '/usr/bin/pbmpscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmpscale' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmreduce is executable
		(SELECT '/usr/bin/pbmreduce is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmreduce is executable

			(SELECT '/usr/bin/pbmreduce is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmreduce' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtext is executable
		(SELECT '/usr/bin/pbmtext is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtext is executable

			(SELECT '/usr/bin/pbmtext is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtext' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmto10x is executable
		(SELECT '/usr/bin/pbmto10x is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto10x is executable

			(SELECT '/usr/bin/pbmto10x is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto10x' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmto4425 is executable
		(SELECT '/usr/bin/pbmto4425 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmto4425 is executable

			(SELECT '/usr/bin/pbmto4425 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmto4425' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoascii is executable
		(SELECT '/usr/bin/pbmtoascii is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoascii is executable

			(SELECT '/usr/bin/pbmtoascii is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoascii' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoatk is executable
		(SELECT '/usr/bin/pbmtoatk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoatk is executable

			(SELECT '/usr/bin/pbmtoatk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoatk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtobbnbg is executable
		(SELECT '/usr/bin/pbmtobbnbg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtobbnbg is executable

			(SELECT '/usr/bin/pbmtobbnbg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtobbnbg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtocmuwm is executable
		(SELECT '/usr/bin/pbmtocmuwm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtocmuwm is executable

			(SELECT '/usr/bin/pbmtocmuwm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtocmuwm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoepsi is executable
		(SELECT '/usr/bin/pbmtoepsi is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepsi is executable

			(SELECT '/usr/bin/pbmtoepsi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepsi' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoepson is executable
		(SELECT '/usr/bin/pbmtoepson is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoepson is executable

			(SELECT '/usr/bin/pbmtoepson is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoepson' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtog3 is executable
		(SELECT '/usr/bin/pbmtog3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtog3 is executable

			(SELECT '/usr/bin/pbmtog3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtog3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtogem is executable
		(SELECT '/usr/bin/pbmtogem is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				OEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogem is executable

			(SELECT '/usr/bin/pbmtogem is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogem' AND
				UEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtogo is executable
		(SELECT '/usr/bin/pbmtogo is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtogo is executable

			(SELECT '/usr/bin/pbmtogo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtogo' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoicon is executable
		(SELECT '/usr/bin/pbmtoicon is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoicon is executable

			(SELECT '/usr/bin/pbmtoicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoicon' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtolj is executable
		(SELECT '/usr/bin/pbmtolj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolj is executable

			(SELECT '/usr/bin/pbmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoln03 is executable
		(SELECT '/usr/bin/pbmtoln03 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoln03 is executable

			(SELECT '/usr/bin/pbmtoln03 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoln03' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtolps is executable
		(SELECT '/usr/bin/pbmtolps is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtolps is executable

			(SELECT '/usr/bin/pbmtolps is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtolps' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomacp is executable
		(SELECT '/usr/bin/pbmtomacp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomacp is executable

			(SELECT '/usr/bin/pbmtomacp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomacp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomda is executable
		(SELECT '/usr/bin/pbmtomda is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomda is executable

			(SELECT '/usr/bin/pbmtomda is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomda' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtomgr is executable
		(SELECT '/usr/bin/pbmtomgr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtomgr is executable

			(SELECT '/usr/bin/pbmtomgr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtomgr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtonokia is executable
		(SELECT '/usr/bin/pbmtonokia is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtonokia is executable

			(SELECT '/usr/bin/pbmtonokia is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtonokia' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopgm is executable
		(SELECT '/usr/bin/pbmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopgm is executable

			(SELECT '/usr/bin/pbmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopi3 is executable
		(SELECT '/usr/bin/pbmtopi3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopi3 is executable

			(SELECT '/usr/bin/pbmtopi3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopi3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopk is executable
		(SELECT '/usr/bin/pbmtopk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopk is executable

			(SELECT '/usr/bin/pbmtopk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoplot is executable
		(SELECT '/usr/bin/pbmtoplot is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoplot is executable

			(SELECT '/usr/bin/pbmtoplot is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoplot' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoppa is executable
		(SELECT '/usr/bin/pbmtoppa is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoppa is executable

			(SELECT '/usr/bin/pbmtoppa is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoppa' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtopsg3 is executable
		(SELECT '/usr/bin/pbmtopsg3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtopsg3 is executable

			(SELECT '/usr/bin/pbmtopsg3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtopsg3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoptx is executable
		(SELECT '/usr/bin/pbmtoptx is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoptx is executable

			(SELECT '/usr/bin/pbmtoptx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoptx' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtowbmp is executable
		(SELECT '/usr/bin/pbmtowbmp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtowbmp is executable

			(SELECT '/usr/bin/pbmtowbmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtowbmp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtox10bm is executable
		(SELECT '/usr/bin/pbmtox10bm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtox10bm is executable

			(SELECT '/usr/bin/pbmtox10bm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtox10bm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoxbm is executable
		(SELECT '/usr/bin/pbmtoxbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoxbm is executable

			(SELECT '/usr/bin/pbmtoxbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoxbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtoybm is executable
		(SELECT '/usr/bin/pbmtoybm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtoybm is executable

			(SELECT '/usr/bin/pbmtoybm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtoybm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmtozinc is executable
		(SELECT '/usr/bin/pbmtozinc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmtozinc is executable

			(SELECT '/usr/bin/pbmtozinc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmtozinc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pbmupc is executable
		(SELECT '/usr/bin/pbmupc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pbmupc is executable

			(SELECT '/usr/bin/pbmupc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pbmupc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pcxtoppm is executable
		(SELECT '/usr/bin/pcxtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pcxtoppm is executable

			(SELECT '/usr/bin/pcxtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pcxtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmbentley is executable
		(SELECT '/usr/bin/pgmbentley is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmbentley is executable

			(SELECT '/usr/bin/pgmbentley is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmbentley' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmcrater is executable
		(SELECT '/usr/bin/pgmcrater is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmcrater is executable

			(SELECT '/usr/bin/pgmcrater is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmcrater' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmedge is executable
		(SELECT '/usr/bin/pgmedge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmedge is executable

			(SELECT '/usr/bin/pgmedge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmedge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmenhance is executable
		(SELECT '/usr/bin/pgmenhance is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmenhance is executable

			(SELECT '/usr/bin/pgmenhance is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmenhance' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmhist is executable
		(SELECT '/usr/bin/pgmhist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmhist is executable

			(SELECT '/usr/bin/pgmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmhist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmkernel is executable
		(SELECT '/usr/bin/pgmkernel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmkernel is executable

			(SELECT '/usr/bin/pgmkernel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmkernel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmnoise is executable
		(SELECT '/usr/bin/pgmnoise is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnoise is executable

			(SELECT '/usr/bin/pgmnoise is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnoise' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmnorm is executable
		(SELECT '/usr/bin/pgmnorm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmnorm is executable

			(SELECT '/usr/bin/pgmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmnorm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmoil is executable
		(SELECT '/usr/bin/pgmoil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmoil is executable

			(SELECT '/usr/bin/pgmoil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmoil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmramp is executable
		(SELECT '/usr/bin/pgmramp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmramp is executable

			(SELECT '/usr/bin/pgmramp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmramp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmslice is executable
		(SELECT '/usr/bin/pgmslice is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmslice is executable

			(SELECT '/usr/bin/pgmslice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmslice' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtexture is executable
		(SELECT '/usr/bin/pgmtexture is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtexture is executable

			(SELECT '/usr/bin/pgmtexture is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtexture' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtofs is executable
		(SELECT '/usr/bin/pgmtofs is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtofs is executable

			(SELECT '/usr/bin/pgmtofs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtofs' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtolispm is executable
		(SELECT '/usr/bin/pgmtolispm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtolispm is executable

			(SELECT '/usr/bin/pgmtolispm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtolispm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtopbm is executable
		(SELECT '/usr/bin/pgmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtopbm is executable

			(SELECT '/usr/bin/pgmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pgmtoppm is executable
		(SELECT '/usr/bin/pgmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pgmtoppm is executable

			(SELECT '/usr/bin/pgmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pgmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pi1toppm is executable
		(SELECT '/usr/bin/pi1toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi1toppm is executable

			(SELECT '/usr/bin/pi1toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi1toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pi3topbm is executable
		(SELECT '/usr/bin/pi3topbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pi3topbm is executable

			(SELECT '/usr/bin/pi3topbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pi3topbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pjtoppm is executable
		(SELECT '/usr/bin/pjtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pjtoppm is executable

			(SELECT '/usr/bin/pjtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pjtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pktopbm is executable
		(SELECT '/usr/bin/pktopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pktopbm is executable

			(SELECT '/usr/bin/pktopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pktopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pngtopnm is executable
		(SELECT '/usr/bin/pngtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pngtopnm is executable

			(SELECT '/usr/bin/pngtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pngtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmalias is executable
		(SELECT '/usr/bin/pnmalias is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmalias is executable

			(SELECT '/usr/bin/pnmalias is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmalias' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmarith is executable
		(SELECT '/usr/bin/pnmarith is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmarith is executable

			(SELECT '/usr/bin/pnmarith is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmarith' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcat is executable
		(SELECT '/usr/bin/pnmcat is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcat is executable

			(SELECT '/usr/bin/pnmcat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcat' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcolormap is executable
		(SELECT '/usr/bin/pnmcolormap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcolormap is executable

			(SELECT '/usr/bin/pnmcolormap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcolormap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcomp is executable
		(SELECT '/usr/bin/pnmcomp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcomp is executable

			(SELECT '/usr/bin/pnmcomp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcomp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmconvol is executable
		(SELECT '/usr/bin/pnmconvol is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmconvol is executable

			(SELECT '/usr/bin/pnmconvol is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmconvol' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcrop is executable
		(SELECT '/usr/bin/pnmcrop is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcrop is executable

			(SELECT '/usr/bin/pnmcrop is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcrop' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmcut is executable
		(SELECT '/usr/bin/pnmcut is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmcut is executable

			(SELECT '/usr/bin/pnmcut is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmcut' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmdepth is executable
		(SELECT '/usr/bin/pnmdepth is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmdepth is executable

			(SELECT '/usr/bin/pnmdepth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmdepth' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmenlarge is executable
		(SELECT '/usr/bin/pnmenlarge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmenlarge is executable

			(SELECT '/usr/bin/pnmenlarge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmenlarge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmfile is executable
		(SELECT '/usr/bin/pnmfile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmfile is executable

			(SELECT '/usr/bin/pnmfile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmfile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmflip is executable
		(SELECT '/usr/bin/pnmflip is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmflip is executable

			(SELECT '/usr/bin/pnmflip is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmflip' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmgamma is executable
		(SELECT '/usr/bin/pnmgamma is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmgamma is executable

			(SELECT '/usr/bin/pnmgamma is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmgamma' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmhisteq is executable
		(SELECT '/usr/bin/pnmhisteq is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhisteq is executable

			(SELECT '/usr/bin/pnmhisteq is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhisteq' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmhistmap is executable
		(SELECT '/usr/bin/pnmhistmap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmhistmap is executable

			(SELECT '/usr/bin/pnmhistmap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmhistmap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnminterp is executable
		(SELECT '/usr/bin/pnminterp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminterp is executable

			(SELECT '/usr/bin/pnminterp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminterp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnminvert is executable
		(SELECT '/usr/bin/pnminvert is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnminvert is executable

			(SELECT '/usr/bin/pnminvert is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnminvert' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmmontage is executable
		(SELECT '/usr/bin/pnmmontage is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmmontage is executable

			(SELECT '/usr/bin/pnmmontage is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmmontage' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmnlfilt is executable
		(SELECT '/usr/bin/pnmnlfilt is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnlfilt is executable

			(SELECT '/usr/bin/pnmnlfilt is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnlfilt' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmnoraw is executable
		(SELECT '/usr/bin/pnmnoraw is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmnoraw is executable

			(SELECT '/usr/bin/pnmnoraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmnoraw' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpad is executable
		(SELECT '/usr/bin/pnmpad is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpad is executable

			(SELECT '/usr/bin/pnmpad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpad' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpaste is executable
		(SELECT '/usr/bin/pnmpaste is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpaste is executable

			(SELECT '/usr/bin/pnmpaste is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpaste' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmpsnr is executable
		(SELECT '/usr/bin/pnmpsnr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmpsnr is executable

			(SELECT '/usr/bin/pnmpsnr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmpsnr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmremap is executable
		(SELECT '/usr/bin/pnmremap is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmremap is executable

			(SELECT '/usr/bin/pnmremap is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmremap' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmrotate is executable
		(SELECT '/usr/bin/pnmrotate is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmrotate is executable

			(SELECT '/usr/bin/pnmrotate is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmrotate' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmscale is executable
		(SELECT '/usr/bin/pnmscale is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscale is executable

			(SELECT '/usr/bin/pnmscale is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscale' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmscalefixed is executable
		(SELECT '/usr/bin/pnmscalefixed is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmscalefixed is executable

			(SELECT '/usr/bin/pnmscalefixed is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmscalefixed' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmshear is executable
		(SELECT '/usr/bin/pnmshear is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmshear is executable

			(SELECT '/usr/bin/pnmshear is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmshear' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmsmooth is executable
		(SELECT '/usr/bin/pnmsmooth is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsmooth is executable

			(SELECT '/usr/bin/pnmsmooth is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsmooth' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmsplit is executable
		(SELECT '/usr/bin/pnmsplit is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmsplit is executable

			(SELECT '/usr/bin/pnmsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmsplit' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtile is executable
		(SELECT '/usr/bin/pnmtile is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtile is executable

			(SELECT '/usr/bin/pnmtile is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtile' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoddif is executable
		(SELECT '/usr/bin/pnmtoddif is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoddif is executable

			(SELECT '/usr/bin/pnmtoddif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoddif' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtofiasco is executable
		(SELECT '/usr/bin/pnmtofiasco is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofiasco is executable

			(SELECT '/usr/bin/pnmtofiasco is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofiasco' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtofits is executable
		(SELECT '/usr/bin/pnmtofits is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtofits is executable

			(SELECT '/usr/bin/pnmtofits is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtofits' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtojpeg is executable
		(SELECT '/usr/bin/pnmtojpeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtojpeg is executable

			(SELECT '/usr/bin/pnmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtojpeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtopalm is executable
		(SELECT '/usr/bin/pnmtopalm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopalm is executable

			(SELECT '/usr/bin/pnmtopalm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopalm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoplainpnm is executable
		(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoplainpnm is executable

			(SELECT '/usr/bin/pnmtoplainpnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoplainpnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtopng is executable
		(SELECT '/usr/bin/pnmtopng is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtopng is executable

			(SELECT '/usr/bin/pnmtopng is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtopng' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtops is executable
		(SELECT '/usr/bin/pnmtops is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtops is executable

			(SELECT '/usr/bin/pnmtops is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtops' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtorast is executable
		(SELECT '/usr/bin/pnmtorast is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorast is executable

			(SELECT '/usr/bin/pnmtorast is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorast' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtorle is executable
		(SELECT '/usr/bin/pnmtorle is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtorle is executable

			(SELECT '/usr/bin/pnmtorle is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtorle' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtosgi is executable
		(SELECT '/usr/bin/pnmtosgi is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosgi is executable

			(SELECT '/usr/bin/pnmtosgi is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosgi' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtosir is executable
		(SELECT '/usr/bin/pnmtosir is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtosir is executable

			(SELECT '/usr/bin/pnmtosir is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtosir' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtotiff is executable
		(SELECT '/usr/bin/pnmtotiff is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiff is executable

			(SELECT '/usr/bin/pnmtotiff is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiff' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtotiffcmyk is executable
		(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtotiffcmyk is executable

			(SELECT '/usr/bin/pnmtotiffcmyk is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtotiffcmyk' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pnmtoxwd is executable
		(SELECT '/usr/bin/pnmtoxwd is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pnmtoxwd is executable

			(SELECT '/usr/bin/pnmtoxwd is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pnmtoxwd' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppm3d is executable
		(SELECT '/usr/bin/ppm3d is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppm3d is executable

			(SELECT '/usr/bin/ppm3d is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppm3d' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmbrighten is executable
		(SELECT '/usr/bin/ppmbrighten is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmbrighten is executable

			(SELECT '/usr/bin/ppmbrighten is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmbrighten' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmchange is executable
		(SELECT '/usr/bin/ppmchange is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmchange is executable

			(SELECT '/usr/bin/ppmchange is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmchange' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcie is executable
		(SELECT '/usr/bin/ppmcie is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcie is executable

			(SELECT '/usr/bin/ppmcie is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcie' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcolormask is executable
		(SELECT '/usr/bin/ppmcolormask is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolormask is executable

			(SELECT '/usr/bin/ppmcolormask is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolormask' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmcolors is executable
		(SELECT '/usr/bin/ppmcolors is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmcolors is executable

			(SELECT '/usr/bin/ppmcolors is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmcolors' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdim is executable
		(SELECT '/usr/bin/ppmdim is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdim is executable

			(SELECT '/usr/bin/ppmdim is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdim' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdist is executable
		(SELECT '/usr/bin/ppmdist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdist is executable

			(SELECT '/usr/bin/ppmdist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmdither is executable
		(SELECT '/usr/bin/ppmdither is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmdither is executable

			(SELECT '/usr/bin/ppmdither is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmdither' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmflash is executable
		(SELECT '/usr/bin/ppmflash is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmflash is executable

			(SELECT '/usr/bin/ppmflash is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmflash' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmforge is executable
		(SELECT '/usr/bin/ppmforge is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmforge is executable

			(SELECT '/usr/bin/ppmforge is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmforge' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmhist is executable
		(SELECT '/usr/bin/ppmhist is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmhist is executable

			(SELECT '/usr/bin/ppmhist is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmhist' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmlabel is executable
		(SELECT '/usr/bin/ppmlabel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmlabel is executable

			(SELECT '/usr/bin/ppmlabel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmlabel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmmake is executable
		(SELECT '/usr/bin/ppmmake is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmake is executable

			(SELECT '/usr/bin/ppmmake is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmake' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmmix is executable
		(SELECT '/usr/bin/ppmmix is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmmix is executable

			(SELECT '/usr/bin/ppmmix is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmmix' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmnorm is executable
		(SELECT '/usr/bin/ppmnorm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmnorm is executable

			(SELECT '/usr/bin/ppmnorm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmnorm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmntsc is executable
		(SELECT '/usr/bin/ppmntsc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmntsc is executable

			(SELECT '/usr/bin/ppmntsc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmntsc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmpat is executable
		(SELECT '/usr/bin/ppmpat is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmpat is executable

			(SELECT '/usr/bin/ppmpat is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmpat' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmquant is executable
		(SELECT '/usr/bin/ppmquant is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmquant is executable

			(SELECT '/usr/bin/ppmquant is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmquant' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmqvga is executable
		(SELECT '/usr/bin/ppmqvga is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmqvga is executable

			(SELECT '/usr/bin/ppmqvga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmqvga' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmrelief is executable
		(SELECT '/usr/bin/ppmrelief is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmrelief is executable

			(SELECT '/usr/bin/ppmrelief is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmrelief' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmshift is executable
		(SELECT '/usr/bin/ppmshift is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmshift is executable

			(SELECT '/usr/bin/ppmshift is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmshift' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmspread is executable
		(SELECT '/usr/bin/ppmspread is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmspread is executable

			(SELECT '/usr/bin/ppmspread is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmspread' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoacad is executable
		(SELECT '/usr/bin/ppmtoacad is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoacad is executable

			(SELECT '/usr/bin/ppmtoacad is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoacad' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtobmp is executable
		(SELECT '/usr/bin/ppmtobmp is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtobmp is executable

			(SELECT '/usr/bin/ppmtobmp is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtobmp' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoeyuv is executable
		(SELECT '/usr/bin/ppmtoeyuv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoeyuv is executable

			(SELECT '/usr/bin/ppmtoeyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoeyuv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtogif is executable
		(SELECT '/usr/bin/ppmtogif is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtogif is executable

			(SELECT '/usr/bin/ppmtogif is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtogif' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoicr is executable
		(SELECT '/usr/bin/ppmtoicr is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoicr is executable

			(SELECT '/usr/bin/ppmtoicr is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoicr' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoilbm is executable
		(SELECT '/usr/bin/ppmtoilbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoilbm is executable

			(SELECT '/usr/bin/ppmtoilbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoilbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtojpeg is executable
		(SELECT '/usr/bin/ppmtojpeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtojpeg is executable

			(SELECT '/usr/bin/ppmtojpeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtojpeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoleaf is executable
		(SELECT '/usr/bin/ppmtoleaf is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoleaf is executable

			(SELECT '/usr/bin/ppmtoleaf is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoleaf' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtolj is executable
		(SELECT '/usr/bin/ppmtolj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtolj is executable

			(SELECT '/usr/bin/ppmtolj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtolj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtomitsu is executable
		(SELECT '/usr/bin/ppmtomitsu is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtomitsu is executable

			(SELECT '/usr/bin/ppmtomitsu is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtomitsu' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtompeg is executable
		(SELECT '/usr/bin/ppmtompeg is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtompeg is executable

			(SELECT '/usr/bin/ppmtompeg is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtompeg' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoneo is executable
		(SELECT '/usr/bin/ppmtoneo is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoneo is executable

			(SELECT '/usr/bin/ppmtoneo is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoneo' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopcx is executable
		(SELECT '/usr/bin/ppmtopcx is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopcx is executable

			(SELECT '/usr/bin/ppmtopcx is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopcx' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopgm is executable
		(SELECT '/usr/bin/ppmtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopgm is executable

			(SELECT '/usr/bin/ppmtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopi1 is executable
		(SELECT '/usr/bin/ppmtopi1 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopi1 is executable

			(SELECT '/usr/bin/ppmtopi1 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopi1' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopict is executable
		(SELECT '/usr/bin/ppmtopict is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopict is executable

			(SELECT '/usr/bin/ppmtopict is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopict' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopj is executable
		(SELECT '/usr/bin/ppmtopj is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopj is executable

			(SELECT '/usr/bin/ppmtopj is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopj' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopjxl is executable
		(SELECT '/usr/bin/ppmtopjxl is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopjxl is executable

			(SELECT '/usr/bin/ppmtopjxl is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopjxl' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtopuzz is executable
		(SELECT '/usr/bin/ppmtopuzz is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtopuzz is executable

			(SELECT '/usr/bin/ppmtopuzz is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtopuzz' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtorgb3 is executable
		(SELECT '/usr/bin/ppmtorgb3 is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtorgb3 is executable

			(SELECT '/usr/bin/ppmtorgb3 is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtorgb3' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtosixel is executable
		(SELECT '/usr/bin/ppmtosixel is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtosixel is executable

			(SELECT '/usr/bin/ppmtosixel is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtosixel' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtotga is executable
		(SELECT '/usr/bin/ppmtotga is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtotga is executable

			(SELECT '/usr/bin/ppmtotga is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtotga' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtouil is executable
		(SELECT '/usr/bin/ppmtouil is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtouil is executable

			(SELECT '/usr/bin/ppmtouil is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtouil' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtowinicon is executable
		(SELECT '/usr/bin/ppmtowinicon is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtowinicon is executable

			(SELECT '/usr/bin/ppmtowinicon is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtowinicon' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoxpm is executable
		(SELECT '/usr/bin/ppmtoxpm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoxpm is executable

			(SELECT '/usr/bin/ppmtoxpm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoxpm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoyuv is executable
		(SELECT '/usr/bin/ppmtoyuv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuv is executable

			(SELECT '/usr/bin/ppmtoyuv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtoyuvsplit is executable
		(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtoyuvsplit is executable

			(SELECT '/usr/bin/ppmtoyuvsplit is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtoyuvsplit' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ppmtv is executable
		(SELECT '/usr/bin/ppmtv is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ppmtv is executable

			(SELECT '/usr/bin/ppmtv is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ppmtv' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/psidtopgm is executable
		(SELECT '/usr/bin/psidtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/psidtopgm is executable

			(SELECT '/usr/bin/psidtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/psidtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/pstopnm is executable
		(SELECT '/usr/bin/pstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/pstopnm is executable

			(SELECT '/usr/bin/pstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/pstopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/qrttoppm is executable
		(SELECT '/usr/bin/qrttoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/qrttoppm is executable

			(SELECT '/usr/bin/qrttoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/qrttoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rasttopnm is executable
		(SELECT '/usr/bin/rasttopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rasttopnm is executable

			(SELECT '/usr/bin/rasttopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rasttopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rawtopgm is executable
		(SELECT '/usr/bin/rawtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtopgm is executable

			(SELECT '/usr/bin/rawtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rawtoppm is executable
		(SELECT '/usr/bin/rawtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rawtoppm is executable

			(SELECT '/usr/bin/rawtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rawtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rgb3toppm is executable
		(SELECT '/usr/bin/rgb3toppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rgb3toppm is executable

			(SELECT '/usr/bin/rgb3toppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rgb3toppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rletopnm is executable
		(SELECT '/usr/bin/rletopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rletopnm is executable

			(SELECT '/usr/bin/rletopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rletopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sbigtopgm is executable
		(SELECT '/usr/bin/sbigtopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sbigtopgm is executable

			(SELECT '/usr/bin/sbigtopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sbigtopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sgitopnm is executable
		(SELECT '/usr/bin/sgitopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sgitopnm is executable

			(SELECT '/usr/bin/sgitopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sgitopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sirtopnm is executable
		(SELECT '/usr/bin/sirtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sirtopnm is executable

			(SELECT '/usr/bin/sirtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sirtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sldtoppm is executable
		(SELECT '/usr/bin/sldtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sldtoppm is executable

			(SELECT '/usr/bin/sldtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sldtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/spctoppm is executable
		(SELECT '/usr/bin/spctoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/spctoppm is executable

			(SELECT '/usr/bin/spctoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spctoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/spottopgm is executable
		(SELECT '/usr/bin/spottopgm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/spottopgm is executable

			(SELECT '/usr/bin/spottopgm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/spottopgm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/sputoppm is executable
		(SELECT '/usr/bin/sputoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/sputoppm is executable

			(SELECT '/usr/bin/sputoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/sputoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tgatoppm is executable
		(SELECT '/usr/bin/tgatoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tgatoppm is executable

			(SELECT '/usr/bin/tgatoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tgatoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/thinkjettopbm is executable
		(SELECT '/usr/bin/thinkjettopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/thinkjettopbm is executable

			(SELECT '/usr/bin/thinkjettopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/thinkjettopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tifftopnm is executable
		(SELECT '/usr/bin/tifftopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tifftopnm is executable

			(SELECT '/usr/bin/tifftopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tifftopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/wbmptopbm is executable
		(SELECT '/usr/bin/wbmptopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/wbmptopbm is executable

			(SELECT '/usr/bin/wbmptopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/wbmptopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/winicontoppm is executable
		(SELECT '/usr/bin/winicontoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/winicontoppm is executable

			(SELECT '/usr/bin/winicontoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/winicontoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xbmtopbm is executable
		(SELECT '/usr/bin/xbmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xbmtopbm is executable

			(SELECT '/usr/bin/xbmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xbmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ximtoppm is executable
		(SELECT '/usr/bin/ximtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ximtoppm is executable

			(SELECT '/usr/bin/ximtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ximtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xpmtoppm is executable
		(SELECT '/usr/bin/xpmtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xpmtoppm is executable

			(SELECT '/usr/bin/xpmtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xpmtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xvminitoppm is executable
		(SELECT '/usr/bin/xvminitoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xvminitoppm is executable

			(SELECT '/usr/bin/xvminitoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xvminitoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xwdtopnm is executable
		(SELECT '/usr/bin/xwdtopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xwdtopnm is executable

			(SELECT '/usr/bin/xwdtopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xwdtopnm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ybmtopbm is executable
		(SELECT '/usr/bin/ybmtopbm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ybmtopbm is executable

			(SELECT '/usr/bin/ybmtopbm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ybmtopbm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/yuvsplittoppm is executable
		(SELECT '/usr/bin/yuvsplittoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvsplittoppm is executable

			(SELECT '/usr/bin/yuvsplittoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvsplittoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/yuvtoppm is executable
		(SELECT '/usr/bin/yuvtoppm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/yuvtoppm is executable

			(SELECT '/usr/bin/yuvtoppm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/yuvtoppm' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/zeisstopnm is executable
		(SELECT '/usr/bin/zeisstopnm is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/zeisstopnm is executable

			(SELECT '/usr/bin/zeisstopnm is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/zeisstopnm' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL811
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0078' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mutt version is less than 1.4.1-3.3

	(SELECT 'mutt version is less than 1.4.1-3.3' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mutt' AND
		RPMTestedEpoch = '5' AND
		RPMTestedVersion = '1.4.1' AND
		RPMTestedRelease = '3.3' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mutt is executable
	(SELECT '/usr/bin/mutt is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL813
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0965' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mailman version is less than 2.1.1-5

	(SELECT 'mailman version is less than 2.1.1-5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mailman' AND
		RPMTestedEpoch = '3' AND
		RPMTestedVersion = '2.1.1' AND
		RPMTestedRelease = '5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening on the network

	(SELECT 'httpd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL815
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0992' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mailman version is less than 2.1.1-5

	(SELECT 'mailman version is less than 2.1.1-5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mailman' AND
		RPMTestedEpoch = '3' AND
		RPMTestedVersion = '2.1.1' AND
		RPMTestedRelease = '5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening on the network

	(SELECT 'httpd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL818
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0006' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gaim version is less than 0.75-0.9.0

	(SELECT 'gaim version is less than 0.75-0.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gaim' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '0.75' AND
		RPMTestedRelease = '0.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/gaim is executable
	(SELECT '/usr/bin/gaim is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL819
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0007' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gaim version is less than 0.75-0.9.0

	(SELECT 'gaim version is less than 0.75-0.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gaim' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '0.75' AND
		RPMTestedRelease = '0.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/gaim is executable
	(SELECT '/usr/bin/gaim is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL820
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0008' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gaim version is less than 0.75-0.9.0

	(SELECT 'gaim version is less than 0.75-0.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gaim' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '0.75' AND
		RPMTestedRelease = '0.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/gaim is executable
	(SELECT '/usr/bin/gaim is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL821
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0848' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- slocate version is less than 2.7-2

	(SELECT 'slocate version is less than 2.7-2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'slocate' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.7' AND
		RPMTestedRelease = '2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/slocate is setgid
	(SELECT '/usr/bin/slocate is setgid' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/slocate is setgid

		(SELECT '/usr/bin/slocate is setgid' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/slocate' AND
			SGID = '1')

	AND EXISTS
		-- /usr/bin/slocate is setgid

		(SELECT '/usr/bin/slocate is setgid' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/slocate' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL822
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1023' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mc version is less than 4.6.0-7.9

	(SELECT 'mc version is less than 4.6.0-7.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mc' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '4.6.0' AND
		RPMTestedRelease = '7.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mc is executable
	(SELECT '/usr/bin/mc is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mc is executable

		(SELECT '/usr/bin/mc is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mc' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mc is executable

		(SELECT '/usr/bin/mc is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mc' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mc is executable

		(SELECT '/usr/bin/mc is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mc' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL823
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0592' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdelibs version is less than 3.1-13

	(SELECT 'kdelibs version is less than 3.1-13' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdelibs' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1' AND
		RPMTestedRelease = '13' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/konqueror is executable
	(SELECT '/usr/bin/konqueror is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL825
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0077' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.21-9.0.1.EL

		(SELECT 'kernel version is less than 2.4.21-9.0.1.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.1.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.21-9.0.1.EL

		(SELECT 'kernel-smp version is less than 2.4.21-9.0.1.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.1.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-hugemem version is less than 2.4.21-9.0.1.EL

		(SELECT 'kernel-hugemem version is less than 2.4.21-9.0.1.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-hugemem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.1.EL' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL826
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0097' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- pwlib version is less than 1.4.7-7.EL

	(SELECT 'pwlib version is less than 1.4.7-7.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'pwlib' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.4.7' AND
		RPMTestedRelease = '7.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- a program is listening on TCP or UDP port 1720

	(SELECT 'a program is listening on TCP or UDP port 1720' FROM RedHat_InetListeningServers WHERE
		LocalPort = '1720' AND
		ProgramName LIKE '%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL827
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0082' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- samba version is less than 3.0.2-6.3E

	(SELECT 'samba version is less than 3.0.2-6.3E' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'samba' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.0.2' AND
		RPMTestedRelease = '6.3E' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smbd is listening on the network

	(SELECT 'smbd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smbd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL828
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0973' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mod_python version is less than 3.0.1-4

	(SELECT 'mod_python version is less than 3.0.1-4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mod_python' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.0.1' AND
		RPMTestedRelease = '4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening to the network

	(SELECT 'httpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL830
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0083' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- XFree86 version is less than 4.3.0-55.EL

	(SELECT 'XFree86 version is less than 4.3.0-55.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'XFree86' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.3.0' AND
		RPMTestedRelease = '55.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/X11R6/bin/XFree86 is SUID and executable
	(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable

		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/X11R6/bin/XFree86' AND
			SUID = '1')

	AND EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable
		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL831
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0084' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- XFree86 version is less than 4.3.0-55.EL

	(SELECT 'XFree86 version is less than 4.3.0-55.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'XFree86' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.3.0' AND
		RPMTestedRelease = '55.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/X11R6/bin/XFree86 is SUID and executable
	(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable

		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/X11R6/bin/XFree86' AND
			SUID = '1')

	AND EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable
		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL832
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0106' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- XFree86 version is less than 4.3.0-55.EL

	(SELECT 'XFree86 version is less than 4.3.0-55.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'XFree86' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.3.0' AND
		RPMTestedRelease = '55.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/X11R6/bin/XFree86 is SUID and executable
	(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable

		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/X11R6/bin/XFree86' AND
			SUID = '1')

	AND EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable
		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL833
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0110' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- libxml2 version is less than 2.5.10-6

		(SELECT 'libxml2 version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libxml2-devel version is less than 2.5.10-6

		(SELECT 'libxml2-devel version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libxml2-python version is less than 2.5.10-6

		(SELECT 'libxml2-python version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2-python' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL834
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0003' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.20-30.9

		(SELECT 'kernel version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.20-30.9

		(SELECT 'kernel-smp version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.20-30.9

		(SELECT 'kernel-bigmem version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL835
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0010' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.20-30.9

		(SELECT 'kernel version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.20-30.9

		(SELECT 'kernel-smp version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.20-30.9

		(SELECT 'kernel-bigmem version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL836
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0075' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.20-30.9

		(SELECT 'kernel version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.20-30.9

		(SELECT 'kernel-smp version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.20-30.9

		(SELECT 'kernel-bigmem version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL837
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0077' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.20-30.9

		(SELECT 'kernel version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.20-30.9

		(SELECT 'kernel-smp version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.20-30.9

		(SELECT 'kernel-bigmem version is less than 2.4.20-30.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '30.9' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL838
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0078' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mutt version is less than 1.4.1-3.4

	(SELECT 'mutt version is less than 1.4.1-3.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mutt' AND
		RPMTestedEpoch = '5' AND
		RPMTestedVersion = '1.4.1' AND
		RPMTestedRelease = '3.4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mutt is executable
	(SELECT '/usr/bin/mutt is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL839
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0973' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mod_python version is less than 3.0.1-4

	(SELECT 'mod_python version is less than 3.0.1-4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mod_python' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.0.1' AND
		RPMTestedRelease = '4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening to the network

	(SELECT 'httpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL845
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0111' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable configuration
	(SELECT 'Vulnerable configuration' FROM Placeholder WHERE

	EXISTS
		-- gdk-pixbuf version is less than 0.22.0-6.0.3

		(SELECT 'gdk-pixbuf version is less than 0.22.0-6.0.3' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.0.3' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- gdk-pixbuf-devel version is less than 0.22.0-6.0.3

		(SELECT 'gdk-pixbuf-devel version is less than 0.22.0-6.0.3' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf-devel' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.0.3' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- gdk-pixbuf-gnome version is less than 0.22.0-6.0.3

		(SELECT 'gdk-pixbuf-gnome version is less than 0.22.0-6.0.3' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf-gnome' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.0.3' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL846
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0111' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable configuration
	(SELECT 'Vulnerable configuration' FROM Placeholder WHERE

	EXISTS
		-- gdk-pixbuf version is less than 0.22.0-6.1.0

		(SELECT 'gdk-pixbuf version is less than 0.22.0-6.1.0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.1.0' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- gdk-pixbuf-devel version is less than 0.22.0-6.1.0

		(SELECT 'gdk-pixbuf-devel version is less than 0.22.0-6.1.0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf-devel' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.1.0' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- gdk-pixbuf-gnome version is less than 0.22.0-6.1.0

		(SELECT 'gdk-pixbuf-gnome version is less than 0.22.0-6.1.0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'gdk-pixbuf-gnome' AND
			RPMTestedEpoch = '1' AND
			RPMTestedVersion = '0.22.0' AND
			RPMTestedRelease = '6.1.0' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL847
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0989' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.9.1

	(SELECT 'tcpdump version is less than 3.7.2-7.9.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.9.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL849
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0107' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- sysstat version is less than 4.0.7-4.rhl9.1

	(SELECT 'sysstat version is less than 4.0.7-4.rhl9.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'sysstat' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.0.7' AND
		RPMTestedRelease = '4.rhl9.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL850
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0055' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.9.1

	(SELECT 'tcpdump version is less than 3.7.2-7.9.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.9.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL851
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0057' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.9.1

	(SELECT 'tcpdump version is less than 3.7.2-7.9.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.9.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL852
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0989' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.E3.1

	(SELECT 'tcpdump version is less than 3.7.2-7.E3.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.E3.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL853
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0055' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.E3.1

	(SELECT 'tcpdump version is less than 3.7.2-7.E3.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.E3.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL854
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0057' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.E3.1

	(SELECT 'tcpdump version is less than 3.7.2-7.E3.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.E3.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL855
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0977' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- cvs version is less than 1.11.2-13

	(SELECT 'cvs version is less than 1.11.2-13' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '13' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- / is world-writable

	(SELECT '/ is world-writable' FROM RedHat_FileAttributes WHERE
		FilePath = '/' AND
		OWRITE = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL856
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1012' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.0a-0.90.1

		(SELECT 'ethereal version is less than 0.10.0a-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.0a' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.0a-0.90.1

		(SELECT 'ethereal-gnome version is less than 0.10.0a-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal=gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.0a' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/tethereal is executable
		(SELECT '/usr/sbin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/tethereal is executable

			(SELECT '/usr/sbin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/tethereal is executable

			(SELECT '/usr/sbin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/tethereal is executable

			(SELECT '/usr/sbin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL857
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-1013' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.0a-0.90.1

		(SELECT 'ethereal version is less than 0.10.0a-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.0a' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.0a-0.90.1

		(SELECT 'ethereal-gnome version is less than 0.10.0a-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal=gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.0a' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/tethereal is executable
		(SELECT '/usr/sbin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/tethereal is executable

			(SELECT '/usr/sbin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/tethereal is executable

			(SELECT '/usr/sbin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/tethereal is executable

			(SELECT '/usr/sbin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL858
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0988' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdepim version is less than 3.1-6

	(SELECT 'kdepim version is less than 3.1-6' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdepim' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1' AND
		RPMTestedRelease = '6' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/share/services/kfile_vcf.desktop is readable
	(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM Placeholder WHERE

	EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			UREAD = '1')

	OR EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL859
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0984' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.20-28.9

		(SELECT 'kernel version is less than 2.4.20-28.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '28.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.20-28.9

		(SELECT 'kernel-smp version is less than 2.4.20-28.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '28.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.20-28.9

		(SELECT 'kernel-bigmem version is less than 2.4.20-28.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '28.9' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL860
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0985' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.20-28.9

		(SELECT 'kernel version is less than 2.4.20-28.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '28.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.20-28.9

		(SELECT 'kernel-smp version is less than 2.4.20-28.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '28.9' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.20-28.9

		(SELECT 'kernel-bigmem version is less than 2.4.20-28.9' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.20' AND
			RPMTestedRelease = '28.9' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL861
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0154' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- nfs-utils version is less than 1.0.6-7.EL

	(SELECT 'nfs-utils version is less than 1.0.6-7.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'nfs-utils' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.0.6' AND
		RPMTestedRelease = '7.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.mountd is listening to the network

	(SELECT 'rpc.mountd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%rpc.mountd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL862
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0107' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- sysstat version is less than 4.0.7-4.EL3.2

	(SELECT 'sysstat version is less than 4.0.7-4.EL3.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'sysstat' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.0.7' AND
		RPMTestedRelease = '4.EL3.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL863
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0542' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.40-21.9

	(SELECT 'httpd version is less than 2.0.40-21.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.40' AND
		RPMTestedRelease = '21.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd.worker is listening on the network

	(SELECT 'httpd.worker is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd.worker%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL864
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0542' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.46-26.ent

	(SELECT 'httpd version is less than 2.0.46-26.ent' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.46' AND
		RPMTestedRelease = '26.ent' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd.worker is listening on the network

	(SELECT 'httpd.worker is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd.worker%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL865
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0988' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdepim version is less than 3.1.3-3.3

	(SELECT 'kdepim version is less than 3.1.3-3.3' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdepim' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1.3' AND
		RPMTestedRelease = '3.3' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/share/services/kfile_vcf.desktop is readable
	(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM Placeholder WHERE

	EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			UREAD = '1')

	OR EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/share/services/kfile_vcf.desktop is readable

		(SELECT '/usr/share/services/kfile_vcf.desktop is readable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/share/services/kfile_vcf.desktop' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL866
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0977' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- cvs version is less than 1.11.2-14

	(SELECT 'cvs version is less than 1.11.2-14' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '14' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- / is world-writable

	(SELECT '/ is world-writable' FROM RedHat_FileAttributes WHERE
		FilePath = '/' AND
		OWRITE = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL867
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0985' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Configuration
	(SELECT 'Vulnerable Configuration' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.21-4.0.2.EL

		(SELECT 'kernel version is less than 2.4.21-4.0.2.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '4.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.21-4.0.2.EL

		(SELECT 'kernel-smp version is less than 2.4.21-4.0.2.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '4.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-bigmem version is less than 2.4.21-4.0.2.EL

		(SELECT 'kernel-bigmem version is less than 2.4.21-4.0.2.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-bigmem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '4.0.2.EL' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL868
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0001' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass = 'x86_64')

AND EXISTS

	-- kernel version is less than 2.4.21-9.EL

	(SELECT 'kernel version is less than 2.4.21-9.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.21' AND
		RPMTestedRelease = '9.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL869
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0935' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- net-snmp version is less than 5.0.9-2.30E.1

	(SELECT 'net-snmp version is less than 5.0.9-2.30E.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'net-snmp' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '5.0.9' AND
		RPMTestedRelease = '2.30E.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- snmpd is listening to the network

	(SELECT 'snmpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%snmpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL870
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0079' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssl version is less than 0.9.7a-33.4

	(SELECT 'openssl version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-devel version is less than 0.9.7a-33.4

	(SELECT 'openssl-devel version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-devel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-perl version is less than 0.9.7a-33.4

	(SELECT 'openssl-perl version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-perl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096b version is less than 0.9.6b-16

	(SELECT 'openssl096b version is less than 0.9.6b-16' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096b' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6b' AND
		RPMTestedRelease = '16' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL871
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0081' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssl version is less than 0.9.7a-33.4

	(SELECT 'openssl version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-devel version is less than 0.9.7a-33.4

	(SELECT 'openssl-devel version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-devel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-perl version is less than 0.9.7a-33.4

	(SELECT 'openssl-perl version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-perl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096b version is less than 0.9.6b-16

	(SELECT 'openssl096b version is less than 0.9.6b-16' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096b' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6b' AND
		RPMTestedRelease = '16' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL872
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0564' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mozilla-nss version is less than 1.4.2-0.9.0

	(SELECT 'mozilla-nss version is less than 1.4.2-0.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mozilla-nss' AND
		RPMTestedEpoch = '37' AND
		RPMTestedVersion = '1.4.2' AND
		RPMTestedRelease = '0.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL873
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0594' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mozilla version is less than 1.4.2-0.9.0

	(SELECT 'mozilla version is less than 1.4.2-0.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mozilla' AND
		RPMTestedEpoch = '37' AND
		RPMTestedVersion = '1.4.2' AND
		RPMTestedRelease = '0.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mozilla is executable
	(SELECT '/usr/bin/mozilla is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL874
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0191' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mozilla version is less than 1.4.2-0.9.0

	(SELECT 'mozilla version is less than 1.4.2-0.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mozilla' AND
		RPMTestedEpoch = '37' AND
		RPMTestedVersion = '1.4.2' AND
		RPMTestedRelease = '0.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mozilla is executable
	(SELECT '/usr/bin/mozilla is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mozilla is executable

		(SELECT '/usr/bin/mozilla is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mozilla' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL875
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0110' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- libxml2 version is less than 2.5.10-6

		(SELECT 'libxml2 version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libxml2-devel version is less than 2.5.10-6

		(SELECT 'libxml2-devel version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libxml2-python version is less than 2.5.10-6

		(SELECT 'libxml2-python version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2-python' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL876
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0113' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mod_ssl version is less than 2.0.46-32.ent

	(SELECT 'mod_ssl version is less than 2.0.46-32.ent' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mod_ssl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.46' AND
		RPMTestedRelease = '32.ent' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening to the network

	(SELECT 'httpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL877
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0189' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- squid version is less than 2.5STABLE1-3.9

	(SELECT 'squid version is less than 2.5STABLE1-3.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squid' AND
		RPMTestedEpoch = '7' AND
		RPMTestedVersion = '2.5STABLE1' AND
		RPMTestedRelease = '3.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- squid is listening on the network

	(SELECT 'squid is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%squid%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL878
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0176' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.90.1

		(SELECT 'ethereal version is less than 0.10.3-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.90.1

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL879
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0365' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.90.1

		(SELECT 'ethereal version is less than 0.10.3-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.90.1

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL880
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0367' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.90.1

		(SELECT 'ethereal version is less than 0.10.3-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.90.1

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.90.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.90.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL887
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0176' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.30E.1

		(SELECT 'ethereal version is less than 0.10.3-0.30E.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.30E.1

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.30E.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL891
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0365' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.30E.1

		(SELECT 'ethereal version is less than 0.10.3-0.30E.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.30E.1

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.30E.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL902
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0081' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssl version is less than 0.9.7a-20

	(SELECT 'openssl version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-devel version is less than 0.9.7a-20

	(SELECT 'openssl-devel version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-devel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-perl version is less than 0.9.7a-20

	(SELECT 'openssl-perl version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-perl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096 version is less than 0.9.6-25.9

	(SELECT 'openssl096 version is less than 0.9.6-25.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6' AND
		RPMTestedRelease = '25.9' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096b version is less than 0.9.6b-15

	(SELECT 'openssl096b version is less than 0.9.6b-15' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096b' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6b' AND
		RPMTestedRelease = '15' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL905
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0367' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.30E.1

		(SELECT 'ethereal version is less than 0.10.3-0.30E.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.30E.1

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.30E.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL914
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0564' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mozilla-nss version is less than 1.4.2-3.0.2

	(SELECT 'mozilla-nss version is less than 1.4.2-3.0.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mozilla-nss' AND
		RPMTestedEpoch = '37' AND
		RPMTestedVersion = '1.4.2' AND
		RPMTestedRelease = '3.0.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL917
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0594' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mozilla-nss version is less than 1.4.2-3.0.2

	(SELECT 'mozilla-nss version is less than 1.4.2-3.0.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mozilla-nss' AND
		RPMTestedEpoch = '37' AND
		RPMTestedVersion = '1.4.2' AND
		RPMTestedRelease = '3.0.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL928
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0112' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssl version is less than 0.9.7a-33.4

	(SELECT 'openssl version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-devel version is less than 0.9.7a-33.4

	(SELECT 'openssl-devel version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-devel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-perl version is less than 0.9.7a-33.4

	(SELECT 'openssl-perl version is less than 0.9.7a-33.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-perl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '33.4' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096b version is less than 0.9.6b-16

	(SELECT 'openssl096b version is less than 0.9.6b-16' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096b' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6b' AND
		RPMTestedRelease = '16' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL937
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0191' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mozilla-nss version is less than 1.4.2-3.0.2

	(SELECT 'mozilla-nss version is less than 1.4.2-3.0.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mozilla-nss' AND
		RPMTestedEpoch = '37' AND
		RPMTestedVersion = '1.4.2' AND
		RPMTestedRelease = '3.0.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL939
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0424' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel versions
	(SELECT 'kernel versions' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel-smp version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-hugemem version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel-hugemem version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-hugemem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL940
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0109' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel versions
	(SELECT 'kernel versions' FROM Placeholder WHERE

	EXISTS
		-- kernel version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel-smp version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-hugemem version is less than 2.4.21-9.0.3.EL

		(SELECT 'kernel-hugemem version is less than 2.4.21-9.0.3.EL' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-hugemem' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '9.0.3.EL' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /bin/mount is world-executable AND Set-UID
	(SELECT '/bin/mount is world-executable AND Set-UID' FROM Placeholder WHERE

	EXISTS
		-- /bin/mount is world-executable AND Set-UID

		(SELECT '/bin/mount is world-executable AND Set-UID' FROM RedHat_FileAttributes WHERE
			FilePath = '/bin/mount' AND
			OEXEC = '1')

	AND EXISTS
		-- /bin/mount is world-executable AND Set-UID

		(SELECT '/bin/mount is world-executable AND Set-UID' FROM RedHat_FileAttributes WHERE
			FilePath = '/bin/mount' AND
			SUID = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL941
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0189' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- squid version is less than 2.5.STABLE3-5.3E

	(SELECT 'squid version is less than 2.5.STABLE3-5.3E' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squid' AND
		RPMTestedEpoch = '7' AND
		RPMTestedVersion = '2.5.STABLE3' AND
		RPMTestedRelease = '5.3E' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- squid is listening on the network

	(SELECT 'squid is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%squid%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL945
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0155' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ipsec-tools version is less than 0.2.5-0.4

	(SELECT 'ipsec-tools version is less than 0.2.5-0.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ipsec-tools' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.2.5' AND
		RPMTestedRelease = '0.4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- racoon is listening on the network

	(SELECT 'racoon is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%racoon%' AND
		Protocol = 'UDP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL947
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0164' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ipsec-tools version is less than 0.2.5-0.4

	(SELECT 'ipsec-tools version is less than 0.2.5-0.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ipsec-tools' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.2.5' AND
		RPMTestedRelease = '0.4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- racoon is listening on the network

	(SELECT 'racoon is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%racoon%' AND
		Protocol = 'UDP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL954
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0411' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdelibs version is less than 3.1.3-6.4

	(SELECT 'kdelibs version is less than 3.1.3-6.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdelibs' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1.3' AND
		RPMTestedRelease = '6.4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- telnet, rlogin, ssh or kmail is executable
	(SELECT 'telnet, rlogin, ssh or kmail is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/telnet is executable
		(SELECT '/usr/bin/telnet is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/telnet is executable

			(SELECT '/usr/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/telnet' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/telnet is executable

			(SELECT '/usr/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/telnet' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/telnet is executable

			(SELECT '/usr/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/telnet' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/kerberos/bin/telnet is executable
		(SELECT '/usr/kerberos/bin/telnet is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/kerberos/bin/telnet is executable

			(SELECT '/usr/kerberos/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/telnet' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/kerberos/bin/telnet is executable

			(SELECT '/usr/kerberos/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/telnet' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/kerberos/bin/telnet is executable

			(SELECT '/usr/kerberos/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/telnet' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rlogin is executable
		(SELECT '/usr/bin/rlogin is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rlogin is executable

			(SELECT '/usr/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rlogin' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rlogin is executable

			(SELECT '/usr/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rlogin' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rlogin is executable

			(SELECT '/usr/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rlogin' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/kerberos/bin/rlogin is executable
		(SELECT '/usr/kerberos/bin/rlogin is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/kerberos/bin/rlogin is executable

			(SELECT '/usr/kerberos/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/rlogin' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/kerberos/bin/rlogin is executable

			(SELECT '/usr/kerberos/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/rlogin' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/kerberos/bin/rlogin is executable

			(SELECT '/usr/kerberos/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/rlogin' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ssh is executable
		(SELECT '/usr/bin/ssh is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ssh is executable

			(SELECT '/usr/bin/ssh is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ssh' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ssh is executable

			(SELECT '/usr/bin/ssh is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ssh' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ssh is executable

			(SELECT '/usr/bin/ssh is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ssh' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/kmail is executable
		(SELECT '/usr/bin/kmail is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/kmail is executable

			(SELECT '/usr/bin/kmail is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/kmail' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/kmail is executable

			(SELECT '/usr/bin/kmail is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/kmail' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/kmail is executable

			(SELECT '/usr/bin/kmail is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/kmail' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL967
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0426' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- rsync version is less than 2.5.7-4.3E

	(SELECT 'rsync version is less than 2.5.7-4.3E' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'rsync' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.5.7' AND
		RPMTestedRelease = '4.3E' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL970
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0396' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- cvs version is less than 1.11.2-22

	(SELECT 'cvs version is less than 1.11.2-22' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '22' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/cvs is executable
	(SELECT '/usr/bin/cvs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL971
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0421' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- libpng/libpng-devel is less than 1.2.2-21 or libpng10/libpng-devel less than 1.0.13 is installed
	(SELECT 'libpng/libpng-devel is less than 1.2.2-21 or libpng10/libpng-devel less than 1.0.13 is installed' FROM Placeholder WHERE

	EXISTS
		-- libpng version is less than 1.2.2-21

		(SELECT 'libpng version is less than 1.2.2-21' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng' AND
			RPMTestedEpoch = '2' AND
			RPMTestedVersion = '1.2.2' AND
			RPMTestedRelease = '21' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng-devel version is less than 1.2.2-21

		(SELECT 'libpng-devel version is less than 1.2.2-21' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng-devel' AND
			RPMTestedEpoch = '2' AND
			RPMTestedVersion = '1.2.2' AND
			RPMTestedRelease = '21' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng10 version is less than 1.0.13-12

		(SELECT 'libpng10 version is less than 1.0.13-12' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.0.13' AND
			RPMTestedRelease = '12' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng10-devel version is less than 1.0.13-12

		(SELECT 'libpng10-devel version is less than 1.0.13-12' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '1.0.13' AND
			RPMTestedRelease = '12' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL972
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0183' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '%3_S%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.E3.2

	(SELECT 'tcpdump version is less than 3.7.2-7.E3.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.E3.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL975
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0079' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssl version is less than 0.9.7a-20

	(SELECT 'openssl version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-devel version is less than 0.9.7a-20

	(SELECT 'openssl-devel version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-devel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-perl version is less than 0.9.7a-20

	(SELECT 'openssl-perl version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-perl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096 version is less than 0.9.6-25.9

	(SELECT 'openssl096 version is less than 0.9.6-25.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6' AND
		RPMTestedRelease = '25.9' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096b version is less than 0.9.6b-15

	(SELECT 'openssl096b version is less than 0.9.6b-15' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096b' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6b' AND
		RPMTestedRelease = '15' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL976
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0184' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '%3_S%')

AND EXISTS

	-- tcpdump version is less than 3.7.2-7.E3.2

	(SELECT 'tcpdump version is less than 3.7.2-7.E3.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'tcpdump' AND
		RPMTestedEpoch = '14' AND
		RPMTestedVersion = '3.7.2' AND
		RPMTestedRelease = '7.E3.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/tcpdump is executable
	(SELECT '/usr/sbin/tcpdump is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/sbin/tcpdump is executable

		(SELECT '/usr/sbin/tcpdump is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/tcpdump' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL977
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0234' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- lha version is less than 1.14i-10.2

	(SELECT 'lha version is less than 1.14i-10.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'lha' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.14i' AND
		RPMTestedRelease = '10.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/lha is executable
	(SELECT '/usr/bin/lha is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL978
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0235' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- lha version is less than 1.14i-10.2

	(SELECT 'lha version is less than 1.14i-10.2' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'lha' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.14i' AND
		RPMTestedRelease = '10.2' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/lha is executable
	(SELECT '/usr/bin/lha is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/lha is executable

		(SELECT '/usr/bin/lha is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/lha' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL979
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0233' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- utempter version is less than 0.5.5-1.3EL.0

	(SELECT 'utempter version is less than 0.5.5-1.3EL.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'utempter' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.5.5' AND
		RPMTestedRelease = '1.3EL.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/sbin/utempter is executable
	(SELECT '/usr/sbin/utempter is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/sbin/utempter is executable

		(SELECT '/usr/sbin/utempter is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/sbin/utempter' AND
			SGID = '1')

	AND EXISTS
		-- /usr/sbin/utempter is executable
		(SELECT '/usr/sbin/utempter is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/utempter is executable

			(SELECT '/usr/sbin/utempter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/utempter' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/utempter is executable

			(SELECT '/usr/sbin/utempter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/utempter' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/utempter is executable

			(SELECT '/usr/sbin/utempter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/utempter' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL980
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0541' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- squid version is less than 2.5.STABLE3-6.3E

	(SELECT 'squid version is less than 2.5.STABLE3-6.3E' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squid' AND
		RPMTestedEpoch = '7' AND
		RPMTestedVersion = '2.5.STABLE3' AND
		RPMTestedRelease = '6.3E' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- squid is listening on the network

	(SELECT 'squid is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%squid%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL982
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0504' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.30E.2

		(SELECT 'ethereal version is less than 0.10.3-0.30E.2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.2' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.30E.2

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.30E.2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.2' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL984
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0403' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ipsec-tools version is less than 0.2.5-0.4

	(SELECT 'ipsec-tools version is less than 0.2.5-0.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ipsec-tools' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.2.5' AND
		RPMTestedRelease = '0.4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- racoon is listening on the network

	(SELECT 'racoon is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%racoon%' AND
		Protocol = 'UDP')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL986
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0505' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.30E.2

		(SELECT 'ethereal version is less than 0.10.3-0.30E.2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.2' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.30E.2

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.30E.2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.2' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL987
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0506' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.30E.2

		(SELECT 'ethereal version is less than 0.10.3-0.30E.2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.2' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.30E.2

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.30E.2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.2' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL988
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0507' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.30E.2

		(SELECT 'ethereal version is less than 0.10.3-0.30E.2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.2' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.30E.2

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.30E.2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.2' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL991
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0523' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- krb5-libs rpm version prior to 1.2.7-24 is installed

	(SELECT 'krb5-libs rpm version prior to 1.2.7-24 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'krb5-libs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.7' AND
		RPMTestedRelease = '24' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL993
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0414' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- cvs rpm version prior to 1.11.2-24 is installed

	(SELECT 'cvs rpm version prior to 1.11.2-24 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '24' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/cvs is executable
	(SELECT '/usr/bin/cvs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL994
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0416' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- cvs rpm version prior to 1.11.2-24 is installed

	(SELECT 'cvs rpm version prior to 1.11.2-24 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '24' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/cvs is executable
	(SELECT '/usr/bin/cvs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL997
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0461' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.21-15.EL

	(SELECT 'kernel version is less than 2.4.21-15.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.21' AND
		RPMTestedRelease = '15.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /proc/tty/driver/serial is world-readable

	(SELECT '/proc/tty/driver/serial is world-readable' FROM RedHat_FileAttributes WHERE
		FilePath = '/proc/tty/driver/serial' AND
		OREAD = '1')

AND EXISTS

	-- /proc/tty/driver/ is world-executable

	(SELECT '/proc/tty/driver/ is world-executable' FROM RedHat_FileAttributes WHERE
		FilePath = '/proc/tty/driver/' AND
		OEXEC = '1')

AND EXISTS

	-- /proc/tty/ is world-executable

	(SELECT '/proc/tty/ is world-executable' FROM RedHat_FileAttributes WHERE
		FilePath = '/proc/tty/' AND
		OEXEC = '1')

AND EXISTS

	-- /proc/ is world-executable

	(SELECT '/proc/ is world-executable' FROM RedHat_FileAttributes WHERE
		FilePath = '/proc/' AND
		OEXEC = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1001
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0417' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- cvs rpm version prior to 1.11.2-24 is installed

	(SELECT 'cvs rpm version prior to 1.11.2-24 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '24' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/cvs is executable
	(SELECT '/usr/bin/cvs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1003
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0418' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- cvs rpm version prior to 1.11.2-24 is installed

	(SELECT 'cvs rpm version prior to 1.11.2-24 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '24' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/cvs is executable
	(SELECT '/usr/bin/cvs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1006
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0519' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- squirrelmail rpm version prior to 1.4.3-0.e3.1 is installed

	(SELECT 'squirrelmail rpm version prior to 1.4.3-0.e3.1 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squirrelmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.4.3' AND
		RPMTestedRelease = '0.e3.1' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- php rpm is installed

	(SELECT 'php rpm is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'php')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening on the network

	(SELECT 'httpd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

AND EXISTS

	-- /etc/httpd/modules/libphp4.so exists

	(SELECT '/etc/httpd/modules/libphp4.so exists' FROM RedHat_FileAttributes WHERE
		FilePath = '/etc/httpd/modules/libphp4.so')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1012
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0520' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- squirrelmail rpm version prior to 1.4.3-0.e3.1 is installed

	(SELECT 'squirrelmail rpm version prior to 1.4.3-0.e3.1 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squirrelmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.4.3' AND
		RPMTestedRelease = '0.e3.1' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- php rpm is installed

	(SELECT 'php rpm is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'php')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening on the network

	(SELECT 'httpd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

AND EXISTS

	-- /etc/httpd/modules/libphp4.so exists

	(SELECT '/etc/httpd/modules/libphp4.so exists' FROM RedHat_FileAttributes WHERE
		FilePath = '/etc/httpd/modules/libphp4.so')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1013
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0984' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.21-15.EL

	(SELECT 'kernel version is less than 2.4.21-15.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.21' AND
		RPMTestedRelease = '15.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1017
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0003' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.21-15.EL

	(SELECT 'kernel version is less than 2.4.21-15.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel-unsupported' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.21' AND
		RPMTestedRelease = '15.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1033
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0521' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- squirrelmail rpm version prior to 1.4.3-0.e3.1 is installed

	(SELECT 'squirrelmail rpm version prior to 1.4.3-0.e3.1 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squirrelmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.4.3' AND
		RPMTestedRelease = '0.e3.1' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- php rpm is installed

	(SELECT 'php rpm is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'php')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening on the network

	(SELECT 'httpd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

AND EXISTS

	-- /etc/httpd/modules/libphp4.so exists

	(SELECT '/etc/httpd/modules/libphp4.so exists' FROM RedHat_FileAttributes WHERE
		FilePath = '/etc/httpd/modules/libphp4.so')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1035
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0010' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.21-15.EL

	(SELECT 'kernel version is less than 2.4.21-15.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel-unsupported' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.21' AND
		RPMTestedRelease = '15.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1042
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0180' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- cvs version is less than 1.11.2-18

	(SELECT 'cvs version is less than 1.11.2-18' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '18' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/cvs is executable
	(SELECT '/usr/bin/cvs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1049
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0112' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openssl version is less than 0.9.7a-20

	(SELECT 'openssl version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-devel version is less than 0.9.7a-20

	(SELECT 'openssl-devel version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-devel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl-perl version is less than 0.9.7a-20

	(SELECT 'openssl-perl version is less than 0.9.7a-20' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl-perl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.7a' AND
		RPMTestedRelease = '20.2' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096 version is less than 0.9.6-25.9

	(SELECT 'openssl096 version is less than 0.9.6-25.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6' AND
		RPMTestedRelease = '25.9' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- openssl096b version is less than 0.9.6b-15

	(SELECT 'openssl096b version is less than 0.9.6b-15' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openssl096b' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.9.6b' AND
		RPMTestedRelease = '15' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1060
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0405' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- cvs version is less than 1.11.2-18

	(SELECT 'cvs version is less than 1.11.2-18' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'cvs' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.11.2' AND
		RPMTestedRelease = '18' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/cvs is executable
	(SELECT '/usr/bin/cvs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/cvs is executable

		(SELECT '/usr/bin/cvs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/cvs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL1065
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0179' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openoffice version is less than 1.1.0-15.EL

	(SELECT 'openoffice version is less than 1.1.0-15.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openoffice' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.0' AND
		RPMTestedRelease = '15.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- OpenOffice Permissions
	(SELECT 'OpenOffice Permissions' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/oocalc is executable
		(SELECT '/usr/bin/oocalc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/oocalc is executable

			(SELECT '/usr/bin/oocalc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oocalc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/oocalc is executable

			(SELECT '/usr/bin/oocalc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oocalc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/oocalc is executable

			(SELECT '/usr/bin/oocalc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oocalc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/oodraw is executable
		(SELECT '/usr/bin/oodraw is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/oodraw is executable

			(SELECT '/usr/bin/oodraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oodraw' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/oodraw is executable

			(SELECT '/usr/bin/oodraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oodraw' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/oodraw is executable

			(SELECT '/usr/bin/oodraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oodraw' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/oofice is executable
		(SELECT '/usr/bin/oofice is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/oofice is executable

			(SELECT '/usr/bin/oofice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oofice' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/oofice is executable

			(SELECT '/usr/bin/oofice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oofice' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/oofice is executable

			(SELECT '/usr/bin/oofice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oofice' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ooimpress is executable
		(SELECT '/usr/bin/ooimpress is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ooimpress is executable

			(SELECT '/usr/bin/ooimpress is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ooimpress' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ooimpress is executable

			(SELECT '/usr/bin/ooimpress is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ooimpress' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ooimpress is executable

			(SELECT '/usr/bin/ooimpress is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ooimpress' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/oowriter is executable
		(SELECT '/usr/bin/oowriter is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/oowriter is executable

			(SELECT '/usr/bin/oowriter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oowriter' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/oowriter is executable

			(SELECT '/usr/bin/oowriter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oowriter' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/oowriter is executable

			(SELECT '/usr/bin/oowriter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oowriter' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL2819
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0427' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- kernel, kernel-hugemem or kernel-smp rpm older than 2.4.21-15.0.2EL Epoch 0
	(SELECT 'kernel, kernel-hugemem or kernel-smp rpm older than 2.4.21-15.0.2EL Epoch 0' FROM Placeholder WHERE

	EXISTS
		-- kernel rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-hugemem rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel-hugemem rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-hugemem' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel-smp rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier'))

AND EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL2915
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0554' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- kernel, kernel-hugemem or kernel-smp rpm older than 2.4.21-15.0.2EL Epoch 0
	(SELECT 'kernel, kernel-hugemem or kernel-smp rpm older than 2.4.21-15.0.2EL Epoch 0' FROM Placeholder WHERE

	EXISTS
		-- kernel rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-hugemem rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel-hugemem rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-hugemem' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel-smp rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL2961
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0495' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- kernel, kernel-hugemem or kernel-smp rpm older than 2.4.21-15.0.2EL Epoch 0
	(SELECT 'kernel, kernel-hugemem or kernel-smp rpm older than 2.4.21-15.0.2EL Epoch 0' FROM Placeholder WHERE

	EXISTS
		-- kernel rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-hugemem rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel-hugemem rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-hugemem' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- kernel-smp rpm older than 2.4.21-15.0.2.EL Epoch 0

		(SELECT 'kernel-smp rpm older than 2.4.21-15.0.2.EL Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'kernel-smp' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '2.4.21' AND
			RPMTestedRelease = '15.0.2.EL' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL3657
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1363' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- libpng or libpng-devel rpm older than 1.2.2-24, Epoch 2 OR libpng10or libpng10-devel rpm older than 1.0.13-14, Epoch 0
	(SELECT 'libpng or libpng-devel rpm older than 1.2.2-24, Epoch 2 OR libpng10or libpng10-devel rpm older than 1.0.13-14, Epoch 0' FROM Placeholder WHERE

	EXISTS
		-- libpng rpm older than 1.2.2-24, Epoch 2

		(SELECT 'libpng rpm older than 1.2.2-24, Epoch 2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng' AND
			RPMTestedEpoch = '2' AND
			RPMTestedVersion = '1.2.2' AND
			RPMTestedRelease = '24' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng-devel rpm older than 1.2.2-24, Epoch 2

		(SELECT 'libpng-devel rpm older than 1.2.2-24, Epoch 2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng-devel' AND
			RPMTestedEpoch = '2' AND
			RPMTestedVersion = '1.2.2' AND
			RPMTestedRelease = '24' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng10-devel rpm older than 1.0.13-14, Epoch 0

		(SELECT 'libpng10-devel rpm older than 1.0.13-14, Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng10-devel' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '1.0.13' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng10 rpm older than 1.0.13-14, Epoch 0

		(SELECT 'libpng10 rpm older than 1.0.13-14, Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng10' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '1.0.13' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

