--
-- OVAL-id: OVAL997
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0461' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kernel version is less than 2.4.21-15.EL

	(SELECT 'kernel version is less than 2.4.21-15.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kernel' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.4.21' AND
		RPMTestedRelease = '15.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /proc/tty/driver/serial is world-readable

	(SELECT '/proc/tty/driver/serial is world-readable' FROM RedHat_FileAttributes WHERE
		FilePath = '/proc/tty/driver/serial' AND
		OREAD = '1')

AND EXISTS

	-- /proc/tty/driver/ is world-executable

	(SELECT '/proc/tty/driver/ is world-executable' FROM RedHat_FileAttributes WHERE
		FilePath = '/proc/tty/driver/' AND
		OEXEC = '1')

AND EXISTS

	-- /proc/tty/ is world-executable

	(SELECT '/proc/tty/ is world-executable' FROM RedHat_FileAttributes WHERE
		FilePath = '/proc/tty/' AND
		OEXEC = '1')

AND EXISTS

	-- /proc/ is world-executable

	(SELECT '/proc/ is world-executable' FROM RedHat_FileAttributes WHERE
		FilePath = '/proc/' AND
		OEXEC = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

