--
-- OVAL-id: OVAL961
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0353' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Affected MDAC versions
	(SELECT 'Affected MDAC versions' FROM Placeholder WHERE

	EXISTS
		-- DataAccess Installed

		(SELECT 'DataAccess Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
			EntryName = 'FullInstallVer' AND
			EntryValue LIKE '2.5%')

	AND EXISTS
		-- File %windir%\System32\odbcbcp.dll is less than 3.70.11.40

		(SELECT 'File %windir%\System32\odbcbcp.dll is less than 3.70.11.40' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 3 OR (Version1 = 3 AND
			(Version2 < 70 OR (Version2 = 70 AND
			(Version3 < 11 OR Version3 = 11 AND
			Version4 < 40)))))))

AND NOT EXISTS

	-- Patch Q823718 Installed

	(SELECT 'Patch Q823718 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q823718' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

