--
-- OVAL-id: OVAL951
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0719' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of schannel.dll is less than 5.1.2195.6899

	(SELECT 'the version of schannel.dll is less than 5.1.2195.6899' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6899))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SSL is enabled

	(SELECT 'SSL is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\W3SVC\%' AND
		Id = '5506')

AND NOT EXISTS

	-- PCT support is disabled

	(SELECT 'PCT support is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\PCT 1.0\Server' AND
		EntryName = 'Enabled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

