--
-- OVAL-id: OVAL945
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0155' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ipsec-tools version is less than 0.2.5-0.4

	(SELECT 'ipsec-tools version is less than 0.2.5-0.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ipsec-tools' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '0.2.5' AND
		RPMTestedRelease = '0.4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- racoon is listening on the network

	(SELECT 'racoon is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%racoon%' AND
		Protocol = 'UDP')

--
-- ### END VULNERABLE CONFIGURATION
;

