--
-- OVAL-id: OVAL941
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0189' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- squid version is less than 2.5.STABLE3-5.3E

	(SELECT 'squid version is less than 2.5.STABLE3-5.3E' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squid' AND
		RPMTestedEpoch = '7' AND
		RPMTestedVersion = '2.5.STABLE3' AND
		RPMTestedRelease = '5.3E' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- squid is listening on the network

	(SELECT 'squid is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%squid%')

--
-- ### END VULNERABLE CONFIGURATION
;

