--
-- OVAL-id: OVAL912
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0507' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\System32\Msw3prt.dll is less than 5.0.2195.3649

	(SELECT 'File %windir%\System32\Msw3prt.dll is less than 5.0.2195.3649' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Msw3prt.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 3649))))))

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

