--
-- OVAL-id: OVAL903
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0719' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of schannel.dll is less than 4.87.1964.1880

	(SELECT 'the version of schannel.dll is less than 4.87.1964.1880' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\schannel.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 87 OR (Version2 = 87 AND
		(Version3 < 1964 OR Version3 = 1964 AND
		Version4 < 1880))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- SSL is enabled

	(SELECT 'SSL is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey LIKE 'LM\W3SVC\%' AND
		Id = '5506')

AND NOT EXISTS

	-- PCT support is disabled

	(SELECT 'PCT support is disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols\PCT 1.0\Server' AND
		EntryName = 'Enabled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

