--
-- OVAL-id: OVAL895
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0806' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- a vulnerable version of msgina.dll exists on NT
	(SELECT 'a vulnerable version of msgina.dll exists on NT' FROM Placeholder WHERE

	EXISTS
		-- non Terminal Server and msgina.dll is less than 4.0.1381.7255
		(SELECT 'non Terminal Server and msgina.dll is less than 4.0.1381.7255' FROM Placeholder WHERE

		NOT EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of msgina.dll is less than 4.0.1381.7255

			(SELECT 'the version of msgina.dll is less than 4.0.1381.7255' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msgina.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 7255)))))))

	OR EXISTS
		-- Terminal Server and msgina.dll is less than 4.0.1381.33559
		(SELECT 'Terminal Server and msgina.dll is less than 4.0.1381.33559' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of msgina.dll is less than 4.0.1381.33559

			(SELECT 'the version of msgina.dll is less than 4.0.1381.33559' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msgina.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 33559))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- machine is a member of a domain

	(SELECT 'machine is a member of a domain' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Netlogon' AND
		EntryName = 'Start' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

