--
-- OVAL-id: OVAL876
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0113' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mod_ssl version is less than 2.0.46-32.ent

	(SELECT 'mod_ssl version is less than 2.0.46-32.ent' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mod_ssl' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.46' AND
		RPMTestedRelease = '32.ent' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening to the network

	(SELECT 'httpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

