--
-- OVAL-id: OVAL79
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0573' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.rwalld exists

	(SELECT 'File rpc.rwalld exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND NOT EXISTS

	-- Patch 112846-01 or later installed

	(SELECT 'Patch 112846-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112846' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.rwalld

	(SELECT 'inetd.conf contains rpc.rwalld' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.rwalld executable
	(SELECT 'File rpc.rwalld executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

