--
-- OVAL-id: OVAL78
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0333' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\ism.dll version is less than 5.0.2195.3407

	(SELECT 'File %windir%\system32\inetsrv\ism.dll version is less than 5.0.2195.3407' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\ism.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 3407))))))

AND NOT EXISTS

	-- Patch Q293826 Installed

	(SELECT 'Patch Q293826 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q293826' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Windows 2000 Security Roll-up 1 Installed

	(SELECT 'Windows 2000 Security Roll-up 1 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\SP2SRP1' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 3 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 3 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

