--
-- OVAL-id: OVAL67
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0089' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

AND NOT EXISTS

	-- Patch 110453-01 or later installed

	(SELECT 'Patch 110453-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110453' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

