--
-- OVAL-id: OVAL6397
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0575' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP is installed

	(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.1')

AND EXISTS

	-- 64-Bit version of Windows is installed

	(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
		EntryName = 'PROCESSOR_ARCHITECTURE' AND
		EntryValue = 'ia64')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 (or later) is installed

	(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10'))

AND EXISTS

	-- the 64-bit WOW version of zipfldr.dll is less than 6.0.2800.1584

	(SELECT 'the 64-bit WOW version of zipfldr.dll is less than 6.0.2800.1584' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\SysWOW64\zipfldr.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2800 OR Version3 = 2800 AND
		Version4 < 1584))))))

AND NOT EXISTS

	-- the patch q873376 is installed (Hotfix key)

	(SELECT 'the patch q873376 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB873376' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- Compressed Folders with zipfldr.dll are enabled

	(SELECT 'Compressed Folders with zipfldr.dll are enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Classes\CompressedFolder' AND
		EntryName = 'FriendlyTypeName' AND
		EntryValue LIKE '%*zipfldr_dll*%')

--
-- ### END VULNERABLE CONFIGURATION
;

