--
-- OVAL-id: OVAL631
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0546' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- up2date version is less than 3.1.23.1-5

	(SELECT 'up2date version is less than 3.1.23.1-5' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'up2date' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.1.23.1' AND
		RPMTestedRelease = '5' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rhnsd is running

	(SELECT 'rhnsd is running' FROM RedHat_PSInfo WHERE
		Command LIKE '%rhnsd%')

--
-- ### END VULNERABLE CONFIGURATION
;

