--
-- OVAL-id: OVAL6
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0195' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- cups version is less than 1.1.17-13.3

	(SELECT 'cups version is less than 1.1.17-13.3' FROM RedHat_RPMVersionCompare WHERE
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.17' AND
		RPMTestedRelease = '13.3' AND
		RPMInstalledVersion = 'earlier' AND
		RPMName = 'cups')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- cupsd listens on the network

	(SELECT 'cupsd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%cupsd%')

--
-- ### END VULNERABLE CONFIGURATION
;

