--
-- OVAL-id: OVAL597
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0688' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- sendmail version is less than 8.12.8-6.90

	(SELECT 'sendmail version is less than 8.12.8-6.90' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'sendmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '8.12.8' AND
		RPMTestedRelease = '6.90' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- sendmail is listening to the network

	(SELECT 'sendmail is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%sendmail%')

--
-- ### END VULNERABLE CONFIGURATION
;

