--
-- OVAL-id: OVAL5740
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0845' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 1 is installed

	(SELECT 'Internet Explorer 6 Service Pack 1 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2800.1106')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2800.1476   

	(SELECT 'the version of mshtml.dll is less than 6.0.2800.1476   ' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2745 OR Version3 = 2745 AND
		Version4 < 2800))))))

AND NOT EXISTS

	-- the patch kb834707 is installed (Installed Components key)

	(SELECT 'the patch kb834707 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{ 3e7bb08a-a7a3-4692-8eac-ac5e7895755b}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Users not saving encrypted pages to disk  (DisableCachingOfSSLPages)

	(SELECT 'Users not saving encrypted pages to disk  (DisableCachingOfSSLPages)' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_USERS\S-[-0-9]+\Software\Microsoft\Windows\CurrentVersion\Internet Settings' AND
		EntryName = 'DisableCachingOfSSLPages' AND
		EntryValue != '1')

--
-- ### END VULNERABLE CONFIGURATION
;

