--
-- OVAL-id: OVAL411
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0459' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdelibs version is less than 3.1-12

	(SELECT 'kdelibs version is less than 3.1-12' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdelibs' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1' AND
		RPMTestedRelease = '12' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/konqueror is executable
	(SELECT '/usr/bin/konqueror is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/konqueror is executable

		(SELECT '/usr/bin/konqueror is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/konqueror' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

