--
-- OVAL-id: OVAL3953
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0208' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- this is an NT Server (stand-alone)

	(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductType' AND
		EntryValue LIKE '%ServerNT%')

AND EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- the patch KB840987 is installed (Hotfix key)

	(SELECT 'the patch KB840987 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840987' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- the version of gdi32.dll is less than 4.0.1381.7270

	(SELECT 'the version of gdi32.dll is less than 4.0.1381.7270' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\gdi32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7270))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

