--
-- OVAL-id: OVAL34
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-1076' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File whodo exists

	(SELECT 'File whodo exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '/usr/sbin/sparcv_/whodo')

AND NOT EXISTS

	-- Patch 111600-01 or later installed

	(SELECT 'Patch 111600-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111600' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File whodo SUID and executable
	(SELECT 'File whodo SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			SUID = '1')

	AND EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

