--
-- OVAL-id: OVAL218
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0346' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- the version of quartz.dll is less than 6.1.5.132

	(SELECT 'the version of quartz.dll is less than 6.1.5.132' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\quartz.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 1 OR (Version2 = 1 AND
		(Version3 < 5 OR Version3 = 5 AND
		Version4 < 132))))))

AND NOT EXISTS

	-- Patch Q19696 is installed

	(SELECT 'Patch Q19696 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q19696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

