--
-- OVAL-id: OVAL1964
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0212' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows XP 32-bit edition is installed
	(SELECT 'Windows XP 32-bit edition is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND EXISTS
		-- 32-Bit version of Windows is installed

		(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
			EntryName = 'PROCESSOR_ARCHITECTURE' AND
			EntryValue = 'x86'))

AND EXISTS

	-- Affected mstask.dll file versions based on service pack levels
	(SELECT 'Affected mstask.dll file versions based on service pack levels' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and mstask.dll is less than 5.1.2600.155
		(SELECT 'no service pack is installed and mstask.dll is less than 5.1.2600.155' FROM Placeholder WHERE

		EXISTS
			-- the version of mstask.dll is less than 5.1.2600.155

			(SELECT 'the version of mstask.dll is less than 5.1.2600.155' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\mstask.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 155))))))

		AND EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion'))

	OR EXISTS
		-- service pack 1 is installed and mstask.dll is less than 5.1.2600.1564
		(SELECT 'service pack 1 is installed and mstask.dll is less than 5.1.2600.1564' FROM Placeholder WHERE

		EXISTS
			-- the version of mstask.dll is less than 5.1.2600.1564

			(SELECT 'the version of mstask.dll is less than 5.1.2600.1564' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\mstask.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1564))))))

		AND EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')))

AND NOT EXISTS

	-- Patch Windows2000-kb841873-x86-enu.exe Installed

	(SELECT 'Patch Windows2000-kb841873-x86-enu.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB841873' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

