--
-- OVAL-id: OVAL1962
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0119' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- The version of ipnathlp.dll is less than 5.2.3790.142 and 64-bit or 32-bit version of Windows is installed
	(SELECT 'The version of ipnathlp.dll is less than 5.2.3790.142 and 64-bit or 32-bit version of Windows is installed' FROM Placeholder WHERE

	EXISTS
		-- The version of ipnathlp.dll is less than 5.2.3790.142 and a 64 bit version of Windows is installed
		(SELECT 'The version of ipnathlp.dll is less than 5.2.3790.142 and a 64 bit version of Windows is installed' FROM Placeholder WHERE

		EXISTS
			-- The version of ipnathlp.dll is less than 5.2.3790.142

			(SELECT 'The version of ipnathlp.dll is less than 5.2.3790.142' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\System32\Ipnathlp.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 2 OR (Version2 = 2 AND
				(Version3 < 3790 OR Version3 = 3790 AND
				Version4 < 142))))))

		AND EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64'))

	OR EXISTS
		-- The version of Ipnathlp.dll is less than 5.2.3790.142 and a 32-bit version of Windows is installed
		(SELECT 'The version of Ipnathlp.dll is less than 5.2.3790.142 and a 32-bit version of Windows is installed' FROM Placeholder WHERE

		EXISTS
			-- The version of ipnathlp.dll is less than 5.2.3790.142

			(SELECT 'The version of ipnathlp.dll is less than 5.2.3790.142' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\System32\Ipnathlp.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 2 OR (Version2 = 2 AND
				(Version3 < 3790 OR Version3 = 3790 AND
				Version4 < 142))))))

		AND EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Negotiate is enabled

	(SELECT 'Negotiate is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6032' AND
		Data LIKE '%Negotiate%')

--
-- ### END VULNERABLE CONFIGURATION
;

