--
-- OVAL-id: OVAL1808
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0119' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- The version of Ipnathlp.dll is less than 5.0.2195.6902

	(SELECT 'The version of Ipnathlp.dll is less than 5.0.2195.6902' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Ipnathlp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\WindowsNT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6902))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Negotiate is enabled

	(SELECT 'Negotiate is enabled' FROM Windows_MetabaseKeys WHERE
		MetabaseKey = 'LM\W3SVC' AND
		Id = '6032' AND
		Data LIKE '%Negotiate%')

--
-- ### END VULNERABLE CONFIGURATION
;

