--
-- OVAL-id: OVAL1455
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1183' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT Server 4.0 is installed
	(SELECT 'Windows NT Server 4.0 is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	AND EXISTS
		-- Windows server product option
		(SELECT 'Windows server product option' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Server (stand-alone)

			(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%ServerNT%')

		OR EXISTS
			-- this is an NT Server (domain controller)

			(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%LanmanNT%')))

AND EXISTS

	-- the version of cryptdlg.dll is less then 5.0.1558.6072

	(SELECT 'the version of cryptdlg.dll is less then 5.0.1558.6072' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\cryptdlg.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1558 OR Version3 = 1558 AND
		Version4 < 6072))))))

AND NOT EXISTS

	-- the patch Q329115 is installed

	(SELECT 'the patch Q329115 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329115' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

