--
-- OVAL-id: OVAL1344
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0212' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- Service Pack 6 Installed (or later)

	(SELECT 'Service Pack 6 Installed (or later)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 6')

AND EXISTS

	-- Internet Explorer 6 is installed

	(SELECT 'Internet Explorer 6 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2600.0000')

AND EXISTS

	-- the version of mstask.dll is less than 4.71.1979.1

	(SELECT 'the version of mstask.dll is less than 4.71.1979.1' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mstask.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 71 OR (Version2 = 71 AND
		(Version3 < 1979 OR Version3 = 1979 AND
		Version4 < 1))))))

AND NOT EXISTS

	-- Patch IE-KB841873-WindowsNT4sp6-x86-ENU.exe Installed

	(SELECT 'Patch IE-KB841873-WindowsNT4sp6-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{bfb56e60-5895-496c-bd6b-459b97142e4c}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

