--
-- OVAL-id: OVAL1056
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0862' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- the version of crypt32.dll is less than 5.131.2600.1123

	(SELECT 'the version of crypt32.dll is less than 5.131.2600.1123' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\crypt32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 131 OR (Version2 = 131 AND
		(Version3 < 2600 OR Version3 = 2600 AND
		Version4 < 1123))))))

AND NOT EXISTS

	-- the patch Q329115 is installed

	(SELECT 'the patch Q329115 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q329115' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

