--
-- OVAL-id: OVAL1028
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0380' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- Outlook Express 6 for Windows 2003 is installed

	(SELECT 'Outlook Express 6 for Windows 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Outlook Express\Version Info' AND
		EntryName = 'Current' AND
		EntryValue = '6,0,3790,0')

AND EXISTS

	-- the version of inetcomm.dll is less than 6.00.3790.137

	(SELECT 'the version of inetcomm.dll is less than 6.00.3790.137' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetcomm.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 00 OR (Version2 = 00 AND
		(Version3 < 37909 OR Version3 = 37909 AND
		Version4 < 137))))))

AND NOT EXISTS

	-- the patch kb837009 is installed

	(SELECT 'the patch kb837009 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB837009' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

