DROP TABLE Solaris_FileAttributes;
DROP TABLE Solaris_InetdConf;
DROP TABLE Solaris_Patches;
DROP TABLE Solaris_Pkginfo;
DROP TABLE Solaris_PSInfo;
DROP TABLE Solaris_Uname;
DROP TABLE Solaris_Passwd;
DROP TABLE Solaris_Shadow;


CREATE TABLE Solaris_FileAttributes
	(FilePath varchar(1024), 
	FileType varchar(32),
	UserID integer,
	GroupID integer,
	Atime integer,
	Ctime integer,
	Mtime integer,
	MD5 varchar(128),
	SUID char,
	SGID char,
	STICKY char,
	UREAD char,
	UWRITE char,
	UEXEC char,
	GREAD char,
	GWRITE char,
	GEXEC char,
	OREAD char,
	OWRITE char,
	OEXEC char);


CREATE TABLE Solaris_InetdConf
	(ServiceName varchar(128),
	EndpointType varchar(32),
	Protocol varchar(32),
	WaitStatus varchar(32),
	ExecAsUser varchar(32),
	ServerProgram varchar(1024),
	ServerArguments varchar(512));


CREATE TABLE Solaris_Patches
	(PatchBase integer,
	PatchVersion integer);


CREATE TABLE Solaris_Pkginfo
	(Pkginst varchar(64),
	Name varchar(1024),
	Category varchar(32),
	Version varchar(32),
	Vendor varchar(256),
	Description varchar(1024));


CREATE TABLE Solaris_PSInfo 
	(UserID varchar(128),
	PID integer,
	PPID integer,
	SchedulingClass varchar(16),
	Priority integer,
	StartTime varchar(32),
	TTY integer,
	ExecTime varchar(32),
	Command varchar(1024));


CREATE TABLE Solaris_Uname
	(OSName varchar(32),
	NodeName varchar(128),
	OSRelease varchar(32),
	OSVersion varchar(64),
	MachineClass varchar(32),
	ProcessorType varchar(32),
	HardwarePlatform varchar(64));


CREATE TABLE Solaris_Passwd
	(Username varchar(128),
	Password varchar(32),
	UserID integer,
	GroupID integer,
	GCOS varchar(256),
	HomeDir varchar(1024),
	LoginShell varchar(1024));


CREATE TABLE Solaris_Shadow
	(Username varchar(128),
	Password varchar(32),
	ChgLst integer,
	ChgAllow integer,
	ChgReq integer,
	ExpWarn integer,
	ExpInact integer,
	ExpDate integer,
	Flag varchar(32));

