//
// $Id: RegistryKeysProbe.h,v 1.1 2004/06/01 17:05:22 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Definition Interpreter.
//
// The OVAL Definition Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Definition Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Definition Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  RegistryKeysProbe
//  author: Andrew Buttner
//			Jon Baker
//  date:   11/19/2003
//
//	Gathers registry data.
//
//****************************************************************************************//

#ifndef __REGISTRYKEYSPROBE_H__
#define __REGISTRYKEYSPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Common.h"
#include "Exception.h"
#include "Log.h"
#include "RegistryKeyData.h"

#include <windows.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class RegistryKeysProbe : public Probe
{
	public:
		RegistryKeysProbe();
		~RegistryKeysProbe();

		pdVector Run(ProbeData*);

		static string GetRegKeyValue(string);
		
	private:
		RegistryKeyData* GetRegistryKey(string, string, string);
		HKEY GetRootKey(string);
		void GetMatchingHives(string, sVector*);
		void GetMatchingKeys(string, string, string, sVector*);
		void GetMatchingNames(string, string, string, sVector*);
		void KeyPatternMatch(string, string, sVector*);
		void RetrieveInfo(string, string, string, DWORD, LPBYTE, DWORD, RegistryKeyData*);
};

class RegistryKeysProbeException : public Exception
{
	public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
		RegistryKeysProbeException();
		RegistryKeysProbeException(string);
		~RegistryKeysProbeException();
};

#endif
