//
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Definition Interpreter.
//
// The OVAL Definition Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Definition Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Definition Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  ActiveDirectoryProbe
//  author: Andrew Buttner
//  date:   02 April 2004
//
//	Gathers acitve directory data.  Need to link to Wldap32.lib and Netapi32.lib
//
//****************************************************************************************//

#ifndef __ACTIVEDIRECTORYPROBE_H__
#define __ACTIVEDIRECTORYPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Common.h"
#include "Exception.h"
#include "Log.h"
#include "ActiveDirectoryData.h"

#include <Dsgetdc.h>
#include <Lm.h>
#include <windows.h>
#include <Winldap.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class ActiveDirectoryProbe : public Probe
{
	public:
		ActiveDirectoryProbe();
		~ActiveDirectoryProbe();

		pdVector Run(ProbeData*);
		
	private:
		ActiveDirectoryData* GetActiveDirectory(string, string, string);

		string BuildDistinguishedName(string, string);
		void DnPatternMatch(string, string, sVector*);
		string GetDomainComponents();
		void GetMatchingDistinguishedNames(string, string, string, sVector*);
		string RemoveDnBase(string, string);
};

class ActiveDirectoryProbeException : public Exception
{
	public:
		ActiveDirectoryProbeException();
		ActiveDirectoryProbeException(string);
		~ActiveDirectoryProbeException();
};

#endif
