//
// $Id: UnameProbe.h,v 1.1 2004/06/01 17:05:22 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  UnameProbe
//  author: Jonathan Baker
//  date:   09 February 2004
//
//  Gathers uname data.
//
//****************************************************************************************//

#ifndef __UNAMEPROBE_H__
#define __UNAMEPROBE_H__

#include "Probe.h"

// Include the probe data class
#include "UnameData.h"

#ifdef LINUX
#include <sys/sysinfo.h>
#endif

#ifdef SUNOS
#include <sys/systeminfo.h>
#endif


#include <sys/utsname.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class UnameProbe : public Probe
{
	public:
		UnameProbe();
		~UnameProbe();

		pdVector Run(ProbeData*);

	private:
		void GetNameInfo();

		UnameData *myUnameData;
};

#endif
