//
// $Id: UnameProbe.cpp,v 1.1 2004/06/01 17:05:22 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//

#include "UnameProbe.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  UnameProbe Class  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
UnameProbe::UnameProbe()
{
	//------------------------------------------------------------------------------------//
	//  ABSTRACT
	//
	//  Simply initialize myUnameData 
	//
	//------------------------------------------------------------------------------------//

	myUnameData = NULL;
}

UnameProbe::~UnameProbe()
{
	//------------------------------------------------------------------------------------//
	//  ABSTRACT
	//
	//  Do nothing for now
	//
	//------------------------------------------------------------------------------------//

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  Public Members  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

pdVector UnameProbe::Run(ProbeData *probeDataIn)
{
	//------------------------------------------------------------------------------------//
	//  ABSTRACT
	//
	//  Get the uname info for this system.
	//	Only call the GetNameInfo method if myUnameData is NULL. Otherwise just copy  
	//	the data in myUnameData to dataIn. 
	//
	//------------------------------------------------------------------------------------//

	pdVector resultVector;
	UnameData *dataIn = (UnameData*) probeDataIn;

	//	Has uname data already been collected? 
	if(myUnameData == NULL)
	{
		myUnameData = new UnameData();
		GetNameInfo();
	}
	
	//	Copy the uname data to the data in object
	dataIn->os_name = myUnameData->os_name;
	dataIn->node_name = myUnameData->node_name;
	dataIn->os_release = myUnameData->os_release;
	dataIn->os_version = myUnameData->os_version;
	dataIn->machine_class = myUnameData->machine_class;


	//	Add the dataIn object to the result vector
	resultVector.push_back(dataIn);

	return resultVector;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  Private Members  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

void UnameProbe::GetNameInfo()
{
	//------------------------------------------------------------------------------------//
	//
	//  ABSTRACT
	//
	//  Get the uname info and put it in the UnameData object
	//
	//------------------------------------------------------------------------------------//
	
	struct utsname tmpName;
	
	if (uname(&tmpName) > -1)
	{
		myUnameData->os_name = tmpName.sysname;
		myUnameData->node_name = tmpName.nodename;
		myUnameData->os_release = tmpName.release;
		myUnameData->os_version = tmpName.version;
		myUnameData->machine_class = tmpName.machine;

		// These two appear to be the same on a Linux system
		myUnameData->processor_type = myUnameData->machine_class;
	}else
	{
		myUnameData->msg = "Error: UnameProbe() unable to get uname information";
	}

	//I am laving this Solaris condition here for reference use
	//When I have to write a Solaris uname probe. I will just use this probe as a template
	/*#ifdef SUNOS

	char buf[64];
	
	memset(buf, '\0', sizeof(buf));
	if (sysinfo(SI_ARCHITECTURE, buf, sizeof(buf)) > -1) 
	{
		processorType = buf;
	}
	
	memset(buf, '\0', sizeof(buf));
	if (sysinfo(SI_PLATFORM, buf, sizeof(buf)) > -1) 
	{
		hardwarePlatform = buf;
	}
	#endif*/
}



