//
// $Id: RPMVersionCompareProbe.h,v 1.1 2004/06/01 17:05:22 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  RPMVersionCompareProbe
//  author: Jay Beale & Jon Baker
//  date:   11 February 2004
//
//  Compares an RPM epoch, version and release to the RPM installed on the 
//  system, to determine whether that RPM must be updated ("patched").
//
//****************************************************************************************//

#ifndef __RPMVERSIONCOMPAREPROBE_H__
#define __RPMVERSIONCOMPAREPROBE_H__

#include "Probe.h"

// Include probe data class
#include "RPMVersionCompareData.h"

#include <rpm/rpmlib.h>
#include <rpm/rpmio.h>
#include <rpm/rpmdb.h>
#include <rpm/rpmts.h>
#include <strings.h>

#include <iostream>
#include <string>

using namespace std;


class RPMVersionCompareProbe : public Probe
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	RPMVersionCompareProbe();
	~RPMVersionCompareProbe();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	pdVector Run(ProbeData*);

private:
	// -----------------------------------------------------------------------
	//	Private mambers
	// -----------------------------------------------------------------------
	void CompareRPMtoGood(RPMVersionCompareData*, pdVector*);
	void CompareRPMtoGoodPatternMatch(RPMVersionCompareData*, pdVector*);
	int sense(char *installed_epoch,char *installed_version,
			char *installed_release,
			const char *epoch, const char *version, const char *release);
	   
	char *readHeaderString(Header header,int_32 tag_id);
	int_32 readHeaderInt32(Header header,int_32 tag_id);
};

#endif
