//
// $Id: RPMInfoProbe.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  RPMInfoProbe
//  author: Jay Beale & Jon Baker
//  date:   09 February 2004
//
//  Gathers version and architecture info for an RPM installed on the system.
//
//****************************************************************************************//

#ifndef __RPMInfoProbe_H__
#define __RPMInfoProbe_H__

#include "Probe.h"

// Include the probe data class
#include "RPMInfoData.h"

// Include required definition interpreter files
#include "Log.h"
#include "Exception.h"
#include "Common.h"

#include <rpm/rpmlib.h>
#include <rpm/rpmio.h>
#include <rpm/rpmts.h>
#include <rpm/rpmdb.h>

#include <fcntl.h>

#include <iostream>
#include <string>
#include <vector>


using namespace std;


class RPMInfoProbe : public Probe
{
	public:
       RPMInfoProbe();
	   ~RPMInfoProbe();       
	   pdVector Run(ProbeData*);

	private:
		void GetRPMInfo(RPMInfoData *, pdVector*);
		void GetRPMInfoPatternMatching(RPMInfoData *, pdVector*);
		char *readHeaderString(Header header, int_32 tag_id);
		int_32 readHeaderInt32(Header header, int_32 tag_id);
};

#endif
